﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Text.RegularExpressions;
using System.Runtime.Serialization;
using System.ComponentModel;
using System.Drawing;

namespace Curse.AddOns
{
    [Serializable]
    [DataContract(Namespace = "Curse.AddOns")]
    public class Game
    {
        private int id;
        private string name;
        private string slug;
        private DateTime dateModified;

        private List<GameAsset> gameAssets = new List<GameAsset>();
        private List<GameFile> gameFiles = new List<GameFile>();

        private List<GameDetectionHint> gameDetectionHints = new List<GameDetectionHint>();
        private List<GameFileParsingRule> gameFileParsingRules = new List<GameFileParsingRule>();

        private List<CategorySection> categorySections = new List<CategorySection>();

        private bool _supportsAddons = true;
        private bool _supportsVoice = true;
        private bool _supportsNotifications = true;
        private int _order = 10;
        private bool _bundleAssets = false;

        public override string ToString()
        {
            return string.Format("{{{0} {1}}}", ID, Name);
        }

        [DataMember]
        public int ID
        {
            get { return id; }
            set { id = value; }
        }
        
        [DataMember]
        public string Name
        {
            get { return name; }
            set { name = value; }
        }
        
        [DataMember]
        public string Slug
        {
            get { return slug; }
            set { slug = value; }
        }

        [DataMember]
        public DateTime DateModified
        {
            get { return dateModified; }
            set { dateModified = value; }
        }

        [DataMember]
        public List<GameAsset> Assets
        {
            get { return gameAssets; }
            set { gameAssets = value; }
        }

        [DataMember]
        public List<GameFile> GameFiles
        {
            get { return gameFiles; }
            set { gameFiles = value; }
        }

        [DataMember]
        public List<GameDetectionHint> GameDetectionHints
        {
            get { return gameDetectionHints; }
            set { gameDetectionHints = value; }
        }

        [DataMember]
        public List<GameFileParsingRule> FileParsingRules
        {
            get { return gameFileParsingRules; }
            set { gameFileParsingRules = value; }
        }

        [DataMember]
        public List<CategorySection> CategorySections
        {
            get { return categorySections; }
            set { categorySections = value; }
        }

        [DataMember]
        public long MaxFreeStorage { get; set; }

        [DataMember]
        public long MaxPremiumStorage { get; set; }

        [DataMember]
        public long MaxFileSize { get; set; }

        [DataMember]
        public string AddOnSettingsFolderFilter { get; set; }

        [DataMember]
        public string AddOnSettingsStartingFolder { get; set; }

        [DataMember]
        public string AddOnSettingsFileFilter { get; set; }

        [DataMember]
        public string AddOnSettingsFileRemovalFilter { get; set; }

        [DataMember]
        public bool SupportsAddons
        {
            get { return _supportsAddons; }
            set { _supportsAddons = value; }
        }

        [DataMember]
        public bool SupportsVoice
        {
            get { return _supportsVoice; }
            set { _supportsVoice = value; }
        }

        [DataMember]
        public int Order
        {
            get { return _order; }
            set { _order = value; }
        }

        [DataMember]
        public bool SupportsNotifications
        {
            get { return _supportsNotifications; }
            set { _supportsNotifications = value; }
        }

        [DataMember]
        public bool BundleAssets
        {
            get { return _bundleAssets; }
            set { _bundleAssets = value; }
        }


        [DataMember]
        public int ProfilerAddOnId
        {
            get;
            set;
        }

		[DataMember]
		public int TwitchGameId
		{
			get;
			set;
		}

		[DataMember]
		public bool SupportsAddonsBetaOnly
		{
			get;
			set;
		}
    }
}
