﻿using System;
using System.Runtime.Serialization;

namespace Curse.AddOns
{
    [Serializable]
    [DataContract]
    public class GameDetectionHint
    {
        private int id;
        private HintType hintType;
        private string hintPath;
        private string hintKey;

        [DataMember]
        public int ID
        {
            get
            {
                return id;
            }
            set
            {
                id = value;
            }
        }

        [DataMember]
        public HintType HintType
        {
            get
            {
                return hintType;
            }
            set
            {
                hintType = value;
            }
        }

        [DataMember]
        public string HintPath
        {
            get
            {
                return hintPath;
            }
            set
            {
                hintPath = value;
            }
        }

        [DataMember]
        public string HintKey
        {
            get
            {
                return hintKey;
            }
            set
            {
                hintKey = value;
            }
        }

        [DataMember]
        public HintOption HintOptions { get; set; }

    }

    public enum HintType
    {
        Registry = 1,
        FilePath = 2
    }

    [Flags]
    public enum HintOption
    {
        None = 0,
        IncludeSubFolders = 1,
        FolderOnly = 2
    }
}
