﻿using System;
using System.Runtime.Serialization;

namespace Curse.AddOns
{
    [Serializable]
    [DataContract]    
    public class GameFile
    {
        private int id;
        private int gameId;
        private string fileName;
        private bool isRequired;
        private GameFileType fileType;
        private GamePlatformType platformType;

        [DataMember]
        public int Id
        {
            get { return id; }
            set { id = value; }
        }

        [DataMember]
        public int GameId
        {
            get { return gameId; }
            set { gameId = value; }
        }

        [DataMember]
        public bool IsRequired
        {
            get { return isRequired; }
            set { isRequired = value; }
        }

        [DataMember]
        public string FileName
        {
            get { return fileName; }
            set { fileName = value; }
        }

        [DataMember]
        public GameFileType FileType
        {
            get { return fileType; }
            set { fileType = value; }
        }

        [DataMember]
        public GamePlatformType PlatformType
        {
            get { return platformType; }
            set { platformType = value; }
        }
    }
    public enum GamePlatformType
    {
        Generic = 1,
        Windows32,
        Windows64,
        Windows,
        OSX
    }
    public enum GameFileType
    {
        Generic = 1,
        Game,
        Launcher,
        ProfilerLockCheck,
    }
}
