﻿using System;
using System.Text.RegularExpressions;
using System.Runtime.Serialization;

namespace Curse.AddOns
{
    [Serializable]
    [DataContract(Namespace = "Curse.AddOns")]
    public class GameFileParsingRule
    {
        [DataMember]
        public string CommentStripPattern
        {
            get;
            set;
        }

        private Regex commentStripRegex = null;
        public Regex CommentStripRegex
        {
            get
            {
                if (CommentStripPattern != null && commentStripRegex == null)
                {
                    commentStripRegex = new Regex(CommentStripPattern);
                }
                return commentStripRegex;
            }
        }

        [DataMember]
        public string FileExtension
        {
            get;
            set;
        }

        [DataMember]
        public string InclusionPattern
        {
            get;
            set;
        }

        private Regex inclusionRegex = null;
        public Regex InclusionRegex
        {
            get
            {
                if (inclusionRegex == null)
                {
                    inclusionRegex = new Regex(InclusionPattern);
                }
                return inclusionRegex;
            }
        }

        public GameFileParsingRule()
        {
        }

        public GameFileParsingRule(string fileExtension, string inclusionPattern, string commentStripPattern)
        {
            if (commentStripPattern != null)
            {
                CommentStripPattern = commentStripPattern;
            }
            FileExtension = fileExtension;
            InclusionPattern = inclusionPattern;
        }

    }
}
