﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Web;
using System.Web.Services;
using System.Configuration;

namespace Curse.Auth
{
    public abstract class AuthenticatableWebService
        : WebService
    {

        private static Dictionary<Int32, Byte[]> sStartupKeys = new Dictionary<int, byte[]>();
        private static Int32 sKeyCounter = 0;
        private const Int32 SHELL_CODE_SIG_START = 28;
        private const Int32 SHELL_CODE_SIG_LENGTH = 200 - 28;
        private static readonly Random sRandom = new System.Random(DateTime.UtcNow.Millisecond);
        private static readonly Byte[] sShellCode = { 0X60, 0XE8, 0X00, 0X00, 0X00, 0X00, 0X5D, 0X81, 0XED, 0X06, 0X00, 0X00, 0X00, 0X8B, 0X44, 0X24, 0X2C, 0X89, 0X85, 0XC2, 0X00, 0X00, 0X00, 0X31, 0XC9, 0X8D, 0X85, 0XC6, 0X00, 0X00, 0X00, 0XC6, 0X00, 0X00, 0X40, 0X41, 0X81, 0XF9, 0X10, 0X00, 0X00, 0X00, 0X75, 0XF3, 0X8D, 0X85, 0XD2, 0X00, 0X00, 0X00, 0X8B, 0X9D, 0XC2, 0X00, 0X00, 0X00, 0X89, 0X18, 0X8D, 0X85, 0XC6, 0X00, 0X00, 0X00, 0X8B, 0X9D, 0XBE, 0X00, 0X00, 0X00, 0X89, 0X18, 0X8D, 0X85, 0XCE, 0X00, 0X00, 0X00, 0X8B, 0X9D, 0XBA, 0X00, 0X00, 0X00, 0X89, 0X18, 0X8B, 0X85, 0XBE, 0X00, 0X00, 0X00, 0X31, 0XC3, 0X8D, 0X85, 0XCA, 0X00, 0X00, 0X00, 0X89, 0X18, 0X8B, 0X4C, 0X24, 0X28, 0X81, 0XE9, 0X01, 0X00, 0X00, 0X00, 0X8B, 0X7C, 0X24, 0X24, 0X01, 0XCF, 0X8A, 0X07, 0XB3, 0X4B, 0X00, 0XCB, 0X30, 0XD8, 0X88, 0XC3, 0X80, 0XE3, 0X07, 0XC0, 0XE3, 0X05, 0XC0, 0XE8, 0X03, 0X08, 0XC3, 0XBE, 0X10, 0X00, 0X00, 0X00, 0X89, 0XC8, 0X39, 0XF0, 0X7C, 0X04, 0X29, 0XF0, 0XEB, 0XF8, 0X89, 0XC2, 0X8D, 0X85, 0XC6, 0X00, 0X00, 0X00, 0X01, 0XD0, 0X8A, 0X00, 0X30, 0XC3, 0X89, 0XF8, 0X88, 0X18, 0X81, 0XF9, 0X00, 0X00, 0X00, 0X00, 0X74, 0X04, 0X49, 0X4F, 0XEB, 0XBE, 0X61, 0XC3, 0X04, 0X03, 0X02, 0X01, 0X40, 0X30, 0X20, 0X10, 0XFF, 0XFF, 0XFF, 0XFF, 0X00, 0X00, 0X00, 0X00, 0X00, 0X00, 0X00, 0X00, 0X00, 0X00, 0X00, 0X00, 0X00, 0X00, 0X00, 0X00 };        
        private static readonly Byte[] sShellSignature = null;
        private static readonly Int32 sShellCodeLength = sShellCode.Length;
        private static readonly Byte[] sShellCodeLengthBytes = System.BitConverter.GetBytes(sShellCodeLength);
        private static RSAEncryption sRsaEncryption = null;

        /*
         * Protected static member data
         * Must be initialized by child web services
        */
        protected static StringCipher sClientCipher = null;
        protected static Authentication sAuthentication = null;
        protected static Byte[] sClientKey;
        //protected static Int32 sMagic = 24645422;
        
        static AuthenticatableWebService()
        {                     
            sRsaEncryption = new RSAEncryption(ConfigurationManager.AppSettings["PrivateKeySource"]);
            sShellSignature = sRsaEncryption.GetShellSignature(sShellCode, SHELL_CODE_SIG_START, SHELL_CODE_SIG_LENGTH);                      
        }
        
        [WebMethod]
        public void GetStartupInfo(String pStartupParameters)
        {
            Byte[] startupParameters = sRsaEncryption.Decrypt(Utility.HexStringToByteArray(pStartupParameters));
         
            Int32 magic = BitConverter.ToInt32(startupParameters, 0) ^ BitConverter.ToInt32(startupParameters, 4);                        
            Byte[] clientEncryptionKey = new Byte[16];
            Buffer.BlockCopy(startupParameters, 8, clientEncryptionKey, 0, 16);

            // Disabled for now. If we ever go back to the public key system, the code is here.            
            //String clientPublicKey = System.Text.Encoding.UTF8.GetString(startupParameters, 8, startupParameters.Length - 8);

            Byte[] presharedKey = new Byte[sClientKey.Length];
            Buffer.BlockCopy(sClientKey, 0, presharedKey, 0, sClientKey.Length);
            Int32 inputOne = 0;
            Int32 inputTwo = 0;
            
            GenerateStartupKey(ref presharedKey, ref inputOne, ref inputTwo, magic);

            if (sKeyCounter == Int32.MaxValue - 1000)
            {
                sKeyCounter = 0;
            }

            Int32 keyId = System.Threading.Interlocked.Increment(ref sKeyCounter);

            lock (sStartupKeys)
            {
                sStartupKeys.Add(keyId, presharedKey);
            }

            Byte[] shellCode = new Byte[sShellCode.Length];
            Buffer.BlockCopy(sShellCode, 0, shellCode, 0, sShellCode.Length);            
            Buffer.BlockCopy(BitConverter.GetBytes((UInt32)inputOne), 0, shellCode, 186, 4);
            Buffer.BlockCopy(BitConverter.GetBytes((UInt32)inputTwo), 0, shellCode, 190, 4);
            Buffer.BlockCopy(BitConverter.GetBytes(sRandom.Next()), 0, shellCode, 194, 4);

            // Client SharedSecret, Sig Position, Sig Length, Length of Shell Code, Shell Code, Signature Length, Signature
            byte[] encryptedResponse = new byte[4 + 4 + 4 + sShellCodeLength + 4 + sShellSignature.Length];
            
            Int32 offset = 0;            
            Buffer.BlockCopy(BitConverter.GetBytes(SHELL_CODE_SIG_START), 0, encryptedResponse, offset, 4);
            offset += 4;
            Buffer.BlockCopy(BitConverter.GetBytes(SHELL_CODE_SIG_LENGTH), 0, encryptedResponse, offset, 4);
            offset += 4;
            Buffer.BlockCopy(sShellCodeLengthBytes, 0, encryptedResponse, offset, 4);
            offset += 4;
            Buffer.BlockCopy(shellCode, 0, encryptedResponse, offset, sShellCodeLength);
            offset += sShellCodeLength;
            Buffer.BlockCopy(BitConverter.GetBytes(sShellSignature.Length), 0, encryptedResponse, offset, 4);
            offset += 4;
            Buffer.BlockCopy(sShellSignature, 0, encryptedResponse, offset, sShellSignature.Length);
            offset += sShellSignature.Length;
                                   
            encryptedResponse = RijndaelEncryption.Encrypt(clientEncryptionKey, encryptedResponse);            
            
            Context.Response.OutputStream.WriteByte((byte)StatusCode.Ok);
            Context.Response.OutputStream.Write(BitConverter.GetBytes(keyId), 0, 4);
            Context.Response.OutputStream.Write(BitConverter.GetBytes(encryptedResponse.Length), 0, 4);
            Context.Response.OutputStream.Write(encryptedResponse, 0, encryptedResponse.Length);
        }

        public void GenerateStartupKey(ref Byte[] pKey, ref Int32 pInputOne, ref Int32 pInputTwo, Int32 pMagic)
        {


            //Logger.Log(ELogLevel.Debug, "localhost", "Input 1: {0}, Input 2: {1}, Input 3: {2}", pInputOne, pInputTwo, pMagic);

            pInputOne = sRandom.Next();
            pInputTwo = sRandom.Next();
          
            Byte[] workBuffer = new Byte[16];

            Buffer.BlockCopy(BitConverter.GetBytes((Int32)pMagic), 0, workBuffer, 4 * 3, 4);
            Buffer.BlockCopy(BitConverter.GetBytes((Int32)pInputTwo), 0, workBuffer, 4 * 0, 4);
            Buffer.BlockCopy(BitConverter.GetBytes((Int32)pInputOne), 0, workBuffer, 4 * 2, 4);
            Buffer.BlockCopy(BitConverter.GetBytes((Int32)(pInputOne ^ pInputTwo)), 0, workBuffer, 4 * 1, 4);

            for (int loopcounter = pKey.Length - 1; loopcounter >= 0x0; loopcounter--)
            {
                byte a = pKey[loopcounter];
                byte xor1 = (byte)((0x4B + (loopcounter & 0xFF)) & 0xFF);
	            a ^= xor1;                
                byte b = (byte)(a & 7);
	            b <<= 5;
	            a >>= 3;
	            a = (byte)(a | b);
                a ^= (workBuffer[loopcounter % 16]);
                pKey[loopcounter] = a;
            }

        }

        /**
         * Publically exposed web method for validating user login credentials
         * Returns a StatusCode in the response stream
         * Returns the user id in the response stream if successful
         * Returns the premium status in the response stream if successful
         * Returns the session key as a hex string in the response stream if successful
         * 
         * @param  pUsername the username to authenticate
         * @param  pPassword the password random padded, encrypted and Base64 encoded by the client
         */
        [WebMethod]
        public void Login(String pUsername, String pPassword)
        {

            try
            {
                Int32 userId;
                String session;
                Byte premium;

                pPassword = sClientCipher.Decrypt(pPassword);
                StatusCode status = sAuthentication.Login(pUsername,
                                                          pPassword,
                                                          out userId,
                                                          out session,
                                                          out premium);
                if (status != StatusCode.Ok)
                {
                    Logger.Log(ELogLevel.Access,
                               Context.Request.GetClientIPAddress().ToString(),
                               "Login failed with status {0}",
                               status);
                    Context.Response.OutputStream.WriteByte((Byte)status);
                    return;
                }

                Byte[] sessionBytes = Encoding.ASCII.GetBytes(session);
                Byte[] userIdBytes = BitConverter.GetBytes(userId);
               
                Context.Response.OutputStream.WriteByte((Byte)StatusCode.Ok);
                Context.Response.OutputStream.Write(userIdBytes, 0, userIdBytes.Length);
                Context.Response.OutputStream.WriteByte(premium);
                Context.Response.OutputStream.Write(sessionBytes, 0, sessionBytes.Length);


                return;
            }
            catch (Exception exc)
            {
                Logger.Log(ELogLevel.Error,
                           Context.Request.GetClientIPAddress().ToString(),
                           "Login Exception: {0}",
                           exc.Message);
            }

            Context.Response.OutputStream.WriteByte((Byte)StatusCode.Unknown);
            return;
        }

        [WebMethod]
        public void SecureLogin(String pUsername, String pPassword, Int32 pStartup)
        {            
            try
            {
                Int32 userId;
                String session;
                Byte premium;
                StringCipher cypher = null;
                
                if(Convert.ToBoolean(ConfigurationManager.AppSettings["InsecureLogin"]))
                {
                    cypher = new StringCipher(sClientKey);
                }
                else
                {
                    if (!sStartupKeys.ContainsKey(pStartup))
                    {
                        Context.Response.OutputStream.WriteByte((Byte)StatusCode.AuthenticationFailed);
                        return;
                    }
                    cypher = new StringCipher(sStartupKeys[pStartup]);
                }
                
                pPassword = cypher.Decrypt(pPassword);
                StatusCode status = sAuthentication.Login(pUsername,
                                                          pPassword,
                                                          out userId,
                                                          out session,
                                                          out premium);
                if (status != StatusCode.Ok)
                {
                    Logger.Log(ELogLevel.Access,
                               Context.Request.GetClientIPAddress().ToString(),
                               "Login failed with status {0}",
                               status);
                    Context.Response.OutputStream.WriteByte((Byte)status);
                    return;
                }

                Byte[] sessionBytes = Encoding.ASCII.GetBytes(session);
                Byte[] userIdBytes = BitConverter.GetBytes(userId);

                lock (sStartupKeys)
                {
                    sStartupKeys.Remove(pStartup);
                }
                Context.Response.OutputStream.WriteByte((Byte)StatusCode.Ok);
                Context.Response.OutputStream.Write(userIdBytes, 0, userIdBytes.Length);
                Context.Response.OutputStream.WriteByte(premium);
                Context.Response.OutputStream.Write(sessionBytes, 0, sessionBytes.Length);
                

                return;
            }
            catch (Exception exc)
            {
                Logger.Log(ELogLevel.Error,
                           Context.Request.GetClientIPAddress().ToString(),
                           "Login Exception: {0}",
                           exc.Message);
            }

            Context.Response.OutputStream.WriteByte((Byte)StatusCode.Unknown);
            return;
        }

        /**
         * Publically exposed web method for validating session keys
         * Returns a StatusCode in the response stream
         * 
         * @param  pSession the session key
         */
        [WebMethod]
        public void ValidateSession(String pSession)
        {
            try
            {
                Int32 userId;
                StatusCode status = sAuthentication.ValidateSessionKeyToUserId(pSession, out userId);
                if (status != StatusCode.Ok)
                {
                    Logger.Log(ELogLevel.Access,
                               Context.Request.GetClientIPAddress().ToString(),
                               "ValidateSessionKeyToUserId failed with status {0}",
                               status);
                    Context.Response.OutputStream.WriteByte((Byte)status);
                    return;
                }

                Context.Response.OutputStream.WriteByte((Byte)StatusCode.Ok);
                return;
            }
            catch (Exception exc)
            {
                Logger.Log(ELogLevel.Error,
                           Context.Request.GetClientIPAddress().ToString(),
                           "ValidateSession Exception: {0}",
                           exc.Message);
            }

            Context.Response.OutputStream.WriteByte((Byte)StatusCode.Unknown);
            return;
        }


    }
}
