﻿using System;

namespace Curse.Auth
{
    /**
     * Class used to suppliment Authentication by maintaining local cached session information
     *
     * @author Michael Comperda
     */
    public sealed class SessionData
    {
        public DateTime Validated = DateTime.UtcNow;
        public Int32 UserId = 0;
        public Byte Premium = 0;
        public String IpAddress = null;
        public DateTime LastAccessed = DateTime.UtcNow;

        /**
         * Initialization constructor
         *
         * @param pUserId  the user id of the cached session data
         * @param pPremium premium level
         */
        public SessionData(Int32 pUserId,
                           Byte pPremium,
                           String pIpAddress)
        {
            UserId = pUserId;
            Premium = pPremium;
            IpAddress = pIpAddress;
        }

        public bool Expired
        {
            get
            {
                return (LastAccessed < DateTime.UtcNow.AddHours(-2));
            }
        }
    }
}
