﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Data.SqlClient;
using Curse.Azeroth.Models.WoW;
using System.Data;

namespace Curse.Azeroth.Models.Extensions
{
    public static class NpcItemExtendedCostExtension
    {
        public static SqlCommand GetMatchingCommand(this NpcItemExtendedCost cost, SqlConnection conn)
        {
            var query = "SELECT Id FROM ItemExtendedCost WHERE PersonalRating = @PersonalRating ";

            var cmd = conn.CreateCommand();
            cmd.Parameters.Add("PersonalRating", SqlDbType.Int).Value = cost.PersonalRating;

            for (int i = 0; i < cost.Items.Count; i++)
            {
                query += string.Format("AND Item{0} = @Item{0} AND ItemQty{0} = @ItemQty{0} ", i + 1);
                cmd.Parameters.Add(string.Format("Item{0}", i + 1), SqlDbType.Int).Value = cost.Items[i].ItemID;
                cmd.Parameters.Add(string.Format("ItemQty{0}", i + 1), SqlDbType.Int).Value = cost.Items[i].Quantity;
            }

            for (int i = 0; i < cost.Currencys.Count; i++)
            {
                query += string.Format("AND Currency{0} = @Currency{0} AND CurrencyQty{0} = @CurrencyQty{0} ", i + 1);
                cmd.Parameters.Add(string.Format("Currency{0}", i + 1), SqlDbType.Int).Value = cost.Currencys[i].CurrencyID;
                cmd.Parameters.Add(string.Format("CurrencyQty{0}", i + 1), SqlDbType.Int).Value = cost.Currencys[i].Quantity;
            }
            cmd.CommandText = query;

            return cmd;
        }
    }
}
