﻿using System;
using Curse.Azeroth;

namespace Curse.Azeroth.Models
{
    public interface IUpdate : IPackable
    {
        // Status
        StatusCode UpdateStatus { get; set; }
        Int32 UserId { get; set; }
        string UserHost { get; set; }
        bool IsTrustedUser { get; set; }
        bool IsSupportedLanguage { get; set; }

        // Header Block
        int Build { get; set; }
        ClientVersion ClientVersion { get; set; }
        string ServerName { get; set; }
        ELocale Language { get; set; }
        Int64 ProfilerVersion { get; set; }

        // Data
        string UpdateData { get; set; }

        // Errors
        PackableStringList Errors { get; set; }

        // Methods
        void Clear();
    }
    public abstract class Update : IUpdate
    {
        // Private Variables
        protected long MinProfilerVersion;
        protected int[] SupportedClientVersions;
        protected string[] SupportedLocals;
        
        // Status
        public StatusCode UpdateStatus { get; set; }
        public Int32 UserId { get; set; }
        public string UserHost { get; set; }
        public bool IsTrustedUser { get; set; }
        public bool IsSupportedLanguage { get; set; }

        // Header Block
        public int Build { get; set; }
        public ClientVersion ClientVersion { get; set; }
        public string ServerName { get; set; }
        public ELocale Language { get; set; }
        public Int64 ProfilerVersion { get; set; }

        // Data
        public string UpdateData { get; set; }

        // Errors
        public PackableStringList Errors { get; set; }

        public Update(long minProfilerVersion, int[] supportedClientVersions, string[] supportedLocals, int userId, bool isTrustedUser)
        {
            MinProfilerVersion = minProfilerVersion;
            SupportedClientVersions = supportedClientVersions;
            SupportedLocals = supportedLocals;
            UserId = userId;
            IsTrustedUser = isTrustedUser;
        }

        #region IUpdate Members
        public abstract void Clear();
        #endregion

        #region IPackable Members
        public abstract bool Read(IReadable buffer);
        public abstract bool Write(IWriteable buffer);
        #endregion
    }
}