﻿using System;
using System.Collections.Generic;
using LuaSerialization;
using Curse.Azeroth.Models.Extensions;

namespace Curse.Azeroth.Models.WoW
{
    public enum NpcGender
    {
        UNKNOWN = 0,
        MALE = 1,
        FEMALE
    }
    public enum NpcClass
    {
        None = 0,
        DeathKnight = 6,
        Druid = 11,
        Hunter = 3,
        Mage = 8,
        Paladin = 2,
        Priest = 5,
        Rogue = 4,
        Shaman = 7,
        Warlock = 9,
        Warrior = 1,
        Monk = 10
    }
    public enum NpcReactionType
    {
        UNKNOWN = 0,
        FRIENDLY = 1,
        HOSTILE,
        NEUTRAL
    }
    public enum NpcReactionFaction
    {
        UNKNOWN = 0,
        HORDE = 1,
        ALLIANCE
    }
    public enum PowerType
    {
        Health = -2,
        Mana = 0,
        Rage = 1,
        Focus = 2,
        Energy = 3,
        Energy2 = 4,
        Runes = 5,
        Runic = 6,
        SoulShard = 7,
        HolyPower = 9,
        Chi = 12,
        ShadowOrbs = 13,
        BurningEmbers = 14,
        DemonicFury = 15
    }
    public enum FactionStandingReputation
    {
        Neutral = 0,
        Friendly = Neutral + 3000,
        Honored = Friendly + 6000,
        Revered = Honored + 12000,
        Exalted = Revered + 21000,
        MaxExalted = Exalted + 999,

        Unfriendly = Neutral - 3000,
        Hostile = Unfriendly - 3000,
        Hated = Hostile - 36000,

        MaxStanding = MaxExalted,
        MinStanding = Hated
    }
    
    public class NpcItem
    {
        public int Id { get; set; }
        public int StackSize { get; set; }
        public int LimitedAvailability { get; set; }
        public int NumAvailable { get; set; }

        public int ExtendedCostID { get; set; }
        public NpcItemExtendedCost ExtendedCost { get; set; }
        
        public int Price { get; set; }
        public CurrencyType CurrencyType { get; set; }
    }
    public class ExtendedCostItem
    {
        public int Quantity { get; set; }
        public int ItemID { get; set; }
    }
    public class ExtendedCostCurrency
    {
        public int Quantity { get; set; }
        public int CurrencyID { get; set; }
        public string CurrenctName { get; set; }
    }
    public class NpcItemExtendedCost
    {
        public int CopperCost { get; set; }
        public int BattleGroundRating { get; set; }
        public int PersonalRating { get; set; }
        public List<ExtendedCostItem> Items = new List<ExtendedCostItem>();
        public List<ExtendedCostCurrency> Currencys = new List<ExtendedCostCurrency>();
    }
    public class NpcReaction
    {
        public int Level { get; set; }
        public NpcReactionFaction Faction { get; set; }
        public NpcReactionType ReactionType { get; set; }
    }
    public class NpcReputation
    {
        public int FactionID { get; set; }
        public string FactionName { get; set; }
        public FactionStandingReputation PlayerStanding { get; set; }
        public int Amount { get; set; }
    }
    public class NpcStats
    {
        public int Level { get; set; }
        public List<Location> Locations = new List<Location>();
        public int MaxHealth { get; set; }
        public PowerType PowerType { get; set; }
        public int PowerValue { get; set; }
        public List<NpcReputation> Reputations = new List<NpcReputation>();
    }
    public class TradeSkillRequirement
    {
        public int ClassID { get; set; }
        public string ClassName { get; set; }
        public int ProfessionID { get; set; }
        public string ProfessionName { get; set; }
        public int SkillID { get; set; }
        public int RequiredLevel { get; set; }
        public int RequiredSkill { get; set; }
    }
    public class Npc
    {
        public int Id { get; set; }
        public bool IsPvP { get; set; }
        public int FactionID { get; set; }
        public string Faction { get; set; }
        public bool Repairs { get; set; }
        public NpcReaction Reaction { get; set; }
        public NpcGender Gender { get; set; }
        public NpcClass Class { get; set; }
        public List<NpcItem> VendorItems = new List<NpcItem>();
        public List<InstanceInfo> Encounters = new List<InstanceInfo>();
        public List<TradeSkillRequirement> TradeSkillRequirements = new List<TradeSkillRequirement>();
        public int LootCount { get; set; }
    }
    
    public class StatData
    {
        [LuaField("locations")]
        public Dictionary<string, LocationStore> Locations = new Dictionary<string, LocationStore>();

        [LuaField("max_health")]
        public int MaxHealth { get; set; }

        [LuaField("power")]
        public string Power { get; set; }

        [LuaField("reputations")]
        public Dictionary<string, int> Reputations = new Dictionary<string, int>();
    }
    public class LootCountData
    {
        [LuaField("drops")]
        public int DropLootCount { get; set; }
    }
    public class NpcData
    {
        [LuaField("is_pvp")]
        public bool IsPvP { get; set; }

        [LuaField("encounter_data")]
        public Dictionary<string, InstanceData> EncounterData = new Dictionary<string, InstanceData>();

        [LuaField("reaction")]
        public string Reaction { get; set; }

        [LuaField("pick_pocket")]
        public string[] PickPocket { get; set; }

        [LuaField("herb_gathering")]
        public string[] HerbGathering { get; set; }

        [LuaField("skinning")]
        public string[] Skinning { get; set; }

        [LuaField("sells")]
        public Dictionary<string, int> Sells = new Dictionary<string, int>();

        [LuaField("genders")]
        public Dictionary<string, bool> Genders = new Dictionary<string, bool>();

        [LuaField("class")]
        public string Class { get; set; }

        [LuaField("faction")]
        public string Faction { get; set; }

        [LuaField("can_repair")]
        public bool Repairs { get; set; }

        [LuaField("teaches")]
        public Dictionary<string, Dictionary<string, Dictionary<int, string>>> Teaches = new Dictionary<string, Dictionary<string, Dictionary<int, string>>>();

        [LuaField("loot_counts")]
        public LootCountData LootCountData { get; set; }
    }
}
