﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Runtime.Serialization;
using System.ComponentModel;

namespace Curse.ClientService.AdminModels
{
    [DataContract]
    public class ServiceStatistics : INotifyPropertyChanged
    {
        #region Events

        [field: NonSerialized]
        public event PropertyChangedEventHandler PropertyChanged;

        protected void OnPropertyChanged(string name)
        {
            PropertyChangedEventHandler handler = PropertyChanged;
            if (handler != null)
            {
                handler(this, new PropertyChangedEventArgs(name));
            }
        }

        #endregion

        [DataMember]
        public DateTime Timestamp
        {
            get;
            set;
        }

        [DataMember]
        public int TotalSessions
        {
            get;
            set;
        }

        [DataMember]
        public List<UserStatistic> UserStatistics
        {
            get;
            set;
        }

        [DataMember]
        public List<SessionStatistic> SessionStatistics
        {
            get;
            set;
        }
        
        public DateTime LocalTimestamp
        {
            get;
            set;
        }

        public int Last5Seconds
        {
            get
            {
                return SessionStatistics.FirstOrDefault(p => p.Interval == ServiceStatisticInterval.Last5Seconds).Count;
            }
        }

        public int Last30Seconds
        {
            get
            {
                return SessionStatistics.FirstOrDefault(p => p.Interval == ServiceStatisticInterval.Last30Seconds).Count;
            }
        }

        public int LastMinute
        {
            get
            {
                return SessionStatistics.FirstOrDefault(p => p.Interval == ServiceStatisticInterval.LastMinute).Count;
            }
        }

       
        public int Last5Minutes
        {
            get
            {
                return SessionStatistics.FirstOrDefault(p => p.Interval == ServiceStatisticInterval.Last5Minutes).Count;
            }
        }

        public int Last10Minutes
        {
            get
            {
                return SessionStatistics.FirstOrDefault(p => p.Interval == ServiceStatisticInterval.Last10Minutes).Count;
            }
        }

        public int LastHour
        {
            get
            {
                return SessionStatistics.FirstOrDefault(p => p.Interval == ServiceStatisticInterval.LastHour).Count;
            }
        }

        public int Last24Hours
        {
            get
            {
                return SessionStatistics.FirstOrDefault(p => p.Interval == ServiceStatisticInterval.Last24Hours).Count;
            }
        }

        public ServiceStatistics()
        {
            SessionStatistics = new List<SessionStatistic>();
            UserStatistics = new List<UserStatistic>();
            Timestamp = DateTime.UtcNow;
        }



    }
}
