﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Runtime.Serialization;
using System.ComponentModel;

namespace Curse.ClientService.AdminModels
{
    [DataContract]
    public class SessionStatistic : INotifyPropertyChanged
    {
        #region Events

        [field: NonSerialized]
        public event PropertyChangedEventHandler PropertyChanged;

        protected void OnPropertyChanged(string name)
        {
            PropertyChangedEventHandler handler = PropertyChanged;
            if (handler != null)
            {
                handler(this, new PropertyChangedEventArgs(name));
            }
        }

        #endregion

        private ServiceStatisticInterval _interval;
        private int _count;
        
        public SessionStatistic(ServiceStatisticInterval interval, int value, DateTime timestamp)
        {
            Interval = interval;
            Count = value;        
        }

        [DataMember]
        public ServiceStatisticInterval Interval
        {
            get
            {
                return _interval;
            }
            set
            {
                _interval = value;
                OnPropertyChanged("Interval");
            }
        }        

        [DataMember]
        public int Count
        {
            get
            {
                return _count;
            }
            set
            {
                if (_count != value)
                {
                    _count = value;
                    OnPropertyChanged("Count");
                }
            }
        }       
    }
}
