﻿using System;
using System.Net;

namespace Curse.ClientService.Models
{

    public enum BugReportType
    {
        CrashReport = 1,
        BugOrDefect,
        FeatureSuggestion,
        LoginIssue,
        StartupIssue,
        OtherIssue,
        AutoReport,
        GameCrash,
        CallQuality,
        PostiveFeedback,
        NegativeFeedback
    }

    public enum BugReportReason
    {
        None,
        Bug,
        FeatureRequest,
        Login,
        Startup,
        Task,
        Patch,
        Other
    }

    public enum BugReportPriority
    {
        Critical = 1,
        High = 2,
        Medium = 3,
        Low = 4
    }

    public class BugReport
    {

        public BugReport()
        {
            BypassVersionFilter = false;
        }

        public bool BypassVersionFilter
        {
            get;
            set;
        }

        public Version ClientVersion
        {
            get;
            set;
        }

        public string Title
        {
            get;
            set;
        }

        public string UsernameOrEmail
        {
            get;
            set;
        }

        public BugReportType Type
        {
            get;
            set;
        }

        public BugReportPriority Priority
        {
            get;
            set;
        }

        public Int64? StackTraceHash
        {
            get;
            set;
        }

        public string UserSettings
        {
            get;
            set;
        }

        public string SystemInformation
        {
            get;
            set;
        }

        public string IncompatibleProcesses
        {
            get;
            set;
        }

        public string GameConfiguration
        {
            get;
            set;
        }

        public string TimeConfiguration
        {
            get;
            set;
        }

        public string LogData
        {
            get;
            set;
        }

        public BugReportAttachment[] Attachments
        {
            get;
            set;
        }

        public string ExceptionDetails
        {
            get;
            set;
        }

        public string ApplicationLocation
        {
            get;
            set;
        }

        public string StepsToReproduce
        {
            get;
            set;
        }

        public IPAddress IPAddress
        {
            get;
            set;

        }

        public int? LastAttemptedVoiceHostID
        {
            get;
            set;
        }

        public int? OverlayExitCode
        {
            get; 
            set;
        }

        public byte? OverlayGameState
        {
            get;
            set;
        }

        public BugReportProcess[] RunningProcesses { get; set; }

        public BugReportPlatform Platform { get; set; }

        public int? CallQuality
        {
            get;
            set;
        }

    }
}
