﻿using System;
using System.IO;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.ServiceModel;

namespace Curse.ClientService.Models
{
    [MessageContract]
    public class CSavedGameSyncMessage : IDisposable
    {
        [MessageHeader(MustUnderstand = true)]
        public int GameID { get; set; }

        [MessageHeader(MustUnderstand = true)]
        public string FileName { get; set; }

        [MessageHeader(MustUnderstand = true)]
        public string ComputerName { get; set; }

        [MessageHeader(MustUnderstand = true)]
        public long Fingerprint { get; set; }

        [MessageHeader(MustUnderstand = true)]
        public DateTime DateModified { get; set; }

        [MessageBodyMember(Order = 1)]
        public Stream FileByteStream{ get; set; }

        public void Dispose()
        {
            if (FileByteStream != null)
            {
                FileByteStream.Dispose();
                FileByteStream = null;
            }
        }
    }

    [MessageContract]
    public class CSavedGameReurnMessage
    {
        
    }
}
