﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Runtime.Serialization;

namespace Curse.ClientService.Models
{

    [DataContract]
    public class CServiceResponse
    {
        [DataMember]
        public EServiceResponseStatus Status
        {
            get;
            set;
        }

        [DataMember]
        public string Message
        {
            get;
            set;
        }
        

        public CServiceResponse() { }

        public CServiceResponse(EServiceResponseStatus status)
        {
            Status = status;            
        } 

        public CServiceResponse(EServiceResponseStatus status, string message)
        {
            Status = status;
            Message = message;
        }       
    }

    [DataContract]
    public class CServiceResponse<T>
    {
        [DataMember]
        public EServiceResponseStatus Status
        {
            get;
            set;
        }

        [DataMember]
        public string Message
        {
            get;
            set;
        }        


        [DataMember]
        public T Value
        {
            get;
            set;
        }

        public CServiceResponse() { }

        public CServiceResponse(EServiceResponseStatus status)
        {
            Status = status;            

        }

        public CServiceResponse(EServiceResponseStatus status, string message)
        {
            Status = status;
            Message = message;
        }

        public CServiceResponse(EServiceResponseStatus status, T value)
        {
            Status = status;            
            Value = value;
        }

        public CServiceResponse(EServiceResponseStatus status, string message, T value)
        {
            Status = status;
            Message = message;
            Value = value;
        }


    }
}
