﻿using System;

namespace Curse.ClientService.Models
{
    [Serializable]
    public class ClientMetric<K, V>
    {
        public K Key { get; set; }
        public V Value { get; set; }

        public ClientMetric(K key, V value)
        {
            Key = key;
            Value = value;
        }
    }

    [Serializable]
    public class GameMetric<K, V>
    {
        public int GameID { get; set; }
        public K Key { get; set; }
        public V Value { get; set; }

        public GameMetric(int gameID, K key, V value)
        {
            GameID = gameID;
            Key = key;
            Value = value;
        }
    }
}
