﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Runtime.Serialization;
using System.ComponentModel;

namespace Curse.ClientService.Models
{
    [DataContract]
    public class SyncedAddon : INotifyPropertyChanged
    {
        #region Events

        [field: NonSerialized]
        public event PropertyChangedEventHandler PropertyChanged;

        protected void OnPropertyChanged(string name)
        {
            PropertyChangedEventHandler handler = PropertyChanged;
            if (handler != null)
            {
                handler(this, new PropertyChangedEventArgs(name));
            }
        }

        #endregion

        [DataMember]
        public int AddonID
        {
            get;
            set;
        }

        [DataMember]
        public int FileID
        {
            get;
            set;
        }
       
    }
}
