﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Runtime.Serialization;
using System.ComponentModel;

namespace Curse.ClientService.Models
{
    [DataContract]
    public class SyncedComputer : INotifyPropertyChanged
    {
        #region Events

        [field: NonSerialized]
        public event PropertyChangedEventHandler PropertyChanged;

        protected void OnPropertyChanged(string name)
        {
            PropertyChangedEventHandler handler = PropertyChanged;
            if (handler != null)
            {
                handler(this, new PropertyChangedEventArgs(name));
            }
        }

        #endregion

        [DataMember]
        public int ComputerID
        {
            get;
            set;
        }

        [DataMember]
        public string ComputerName
        {
            get;
            set;
        }

        [DataMember]
        public string InstanceGuid
        {
            get;
            set;
        }

        [DataMember]
        public string InstanceLabel
        {
            get;
            set;
        }

        public string DisplayLabel
        {
            get
            {
                return ComputerName + " - " + InstanceLabel;
            }
        }
        
    }
}
