﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Runtime.Serialization;

namespace Curse.ClientService.Models
{
    public enum UsageProfilePlatform
    {
        Windows,
        Mac,
        iOS,
        Android,
        WindowsPhone
    }

    [DataContract]
    public class UsageProfile
    {
        public int UserID
        {
            get;
            set;
        }

        public DateTime Timestamp
        {
            get;
            set;
        }

        [DataMember]
        public string ClientVersion
        {
            get;
            set;
        }

        [DataMember]
        public string OperatingSystemVersion
        {
            get;
            set;
        }

        [DataMember]
        public string OperatingSystemPlatform
        {
            get;
            set;
        }

        [DataMember]
        public int[] InstalledAddons
        {
            get;
            set;
        }
       
        [DataMember]
        public double MainWindowHeight
        {
            get;
            set;
        }

        [DataMember]
        public double MainWindowWidth
        {
            get;
            set;
        }        

        [DataMember]
        public bool ViewShowSidebar
        {
            get;
            set;
        }

        [DataMember]
        public bool ViewShowGameHeader
        {
            get;
            set;
        }

        [DataMember]
        public bool ViewShowToolbarLabel
        {
            get;
            set;
        }       

        [DataMember]
        public int DefaultGameID
        {
            get;
            set;
        }

        [DataMember]
        public string ReferralCode
        {
            get;
            set;
        }

        [DataMember]
        public List<GameMetric> GameMetrics
        {
            get { return _gameMetrics; }
            set { _gameMetrics = value; }
        }

        List<GameMetric> _gameMetrics = new List<GameMetric>();

        [DataMember]
        public bool RoundedCorners { get; set; }

        [DataMember]
        public bool SoftwareRendering { get; set; }

        [DataMember]
        public float DotNetVersion { get; set; }

        [DataMember]
        public string CountryCode { get; set; }

        [DataMember]
        public UsageProfilePlatform Platform { get; set; }
    }
}
