﻿using System;

namespace Curse.ClientService.Models
{
    public enum UserAbuseReportReason
    {
        Unknown,
        InappropriateContent = 1,
        Harassment,
        Spam,
        Other
    }

    public enum UserAbuseReportStatus
    {
        New = 1,
        UnderReview,
        Resolved,
        Declined
    }

    public enum ClientPlatform
    {
        Unknown,
        Windows = 1,
        Mac,
        iPhone,
        Android
    }

    public class UserAbuseReport
    {
        #region Reporting User

        public int ReporterUserID { get; set; }

        public string ReporterUsername { get; set; }

        public ClientPlatform ReporterPlatform { get; set; }

        #endregion

        #region Reported User

        public int ReportedUserID { get; set; }

        public DateTime ReportedUserRegistrationDate { get; set; }

        public int ReportedUserFriendCount { get; set; }

        public string ReportedUserAvatarUrl { get; set; }

        public string ReportedUsername { get; set; }

        public string ReportedUserDisplayName { get; set; }

        public string ReportedUserCity { get; set; }

        public string ReportedUserState { get; set; }

        public string ReportedUserCountry { get; set; }

        public string ReportedUserAboutMeText { get; set; }

        #endregion

        #region Incident Details

        public DateTime Timestamp { get; set; }

        public UserAbuseReportReason Reason { get; set; }

        public string Description { get; set; }

        public UserAbuseReportStatus Status { get; set; }

        #endregion
    }
}
