﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Curse.MurmurHash;

namespace Curse.DownloadSecurity.Tokens
{
    public static class SecurityToken
    {

        private const int SEED = 1;

        /// <summary>
        /// Encodes the addon id and date into a murmurhashed string
        /// </summary>
        /// <param name="pAddOnId">The ProjectId of the addon to encode</param>
        /// <param name="pDate">The current date and time in UTC</param>
        /// <returns></returns>
        public static UInt32 GetHashCode(int pAddOnId, DateTime pDate)
        {

            int[] hashVals = new int[6];

            // Date Parts
            hashVals[0] = pDate.Year;
            hashVals[1] = pDate.Month;
            hashVals[2] = pDate.Day;
            hashVals[3] = pDate.Hour;
            hashVals[4] = pDate.Minute;

            // File ID
            hashVals[5] = pAddOnId;

            string hashCode = string.Empty;
            for (int i = 0; i < hashVals.Length; i++)
            {
                hashCode += hashVals[i];
            }
            byte[] hashBytes = System.Text.Encoding.ASCII.GetBytes(hashCode);

            return MurmurHash2.GetHashCode(ref hashBytes, hashBytes.Length, SEED);
        }

        [Obsolete("Due to issues with user IPs, please migrate to the version that does not encode the ip address")]
        public static UInt32 GetHashCode(string pIpAddress, int pAddOnId, DateTime pDate)
        {
            string[] ipArray = pIpAddress.Split('.');
            if (ipArray.Length != 4)
            {
                return 0;
            }

            int[] hashVals = new int[10];

            // IP Parts
            hashVals[0] = int.Parse(ipArray[0]);
            hashVals[1] = int.Parse(ipArray[1]);
            hashVals[2] = int.Parse(ipArray[2]);
            hashVals[3] = 0;        // Ignore differences in the subnet level

            // Date Parts
            hashVals[4] = pDate.Year;
            hashVals[5] = pDate.Month;
            hashVals[6] = pDate.Day;
            hashVals[7] = pDate.Hour;
            hashVals[8] = pDate.Minute;

            // File ID
            hashVals[9] = pAddOnId;

            string hashCode = string.Empty;
            for (int i = 0; i < hashVals.Length; i++)
            {
                hashCode += hashVals[i];
            }
            byte[] hashBytes = System.Text.Encoding.ASCII.GetBytes(hashCode);

            return MurmurHash2.GetHashCode(ref hashBytes, hashBytes.Length, SEED);

        }
    }
}
