﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Curse.MurmurHash;

namespace Curse.Logging.Extensions
{
    public static class ExceptionExtensions
    {
        private const int SEED = 1;

        public static string GetCompleteDetails(this Exception ex)
        {
            string exceptionMessage = string.Empty;
            while (ex != null)
            {
                if (exceptionMessage != string.Empty)
                {
                    exceptionMessage += Environment.NewLine;
                }
                exceptionMessage += "Type: " + ex.GetType().ToString()
                    + Environment.NewLine + Environment.NewLine
                    + "Message: " + ex.Message
                    + Environment.NewLine + Environment.NewLine
                    + "Stack Trace: " + ex.StackTrace
                    + Environment.NewLine;

                ex = ex.InnerException;
            }
            return exceptionMessage;
        }        

        public static string[] GetAllStackTraces(this Exception ex)
        {
            List<string> stacks = new List<string>();
            while (ex != null)
            {
                stacks.Add(ex.StackTrace ?? string.Empty);
                ex = ex.InnerException;
            }
            return stacks.ToArray();
        }

        public static UInt32 ComputeHash(this Exception ex)
        {
            string tokens = ex.GetType().Name + "-" + string.Join("-", ex.GetAllStackTraces());
            byte[] byteValues = Encoding.UTF8.GetBytes(tokens);
            return MurmurHash2.GetHashCode(ref byteValues, byteValues.Length, SEED);
        }
    }
}
