function MediaBox(opts)
{
    this.parent = opts.parent;
    this.data = opts.data;
    this.timer_interval = (opts.timer_interval || 7) * 1000;
    this.auto_rotate = (opts.auto_rotate !== undefined ? opts.auto_rotate : true);
    if (!opts.data.length) return;
    this.id = 'mbox_' + Math.floor(Math.random(1, 9)*1000000);
    this.render();
    this.pageSize = opts.pageSize;
}
MediaBox.prototype.pageSize = 5;
MediaBox.prototype.parent;
MediaBox.prototype.mediabox;
MediaBox.prototype.backgroundImage;
MediaBox.prototype.data;
MediaBox.prototype.active;
MediaBox.prototype.page;
MediaBox.prototype.timer_interval;
MediaBox.prototype.auto_rotate;
MediaBox.prototype._timer;
// [['name', 'summary', 'type', 'url', 'thumb_path', 'img_path'], ...]
// [['WoW Comic Contest: Honorable Mentions', 'Here is the next honorable mention comic submitted by Kxhara ...', 'Hot Story', '#']]
MediaBox.prototype.is_loading;
MediaBox.prototype.render = function()
{
    $(this.parent).append(this.generate());
    this.show(0);
};
MediaBox.prototype.show = function(n, show_animation) {
    //  cur needed b/c IE6/7 switching in IE6/7 dont work w/
    //  self = this;
    //  for some reason
    var cur = this;
    n = parseInt(n);
    if (this.is_loading) return;
    if (n == this.active) return;
    if (n + 1 > this.data.length) return;
    if (parseInt(n / this.pageSize) != this.page) this.draw_slots(n / this.pageSize);
    this.active = n;
    this.is_loading = true;
    this.reset_timer();
    $('ul.nav li', this.mediabox).removeClass('selected');
    $('ul.nav li[@num=' + n + ']', this.mediabox).addClass('selected');
    var cur = $('div.container', this.mediabox);
    cur.css('display', 'none');

    // Capture current image to use for fade out
    $('div.previous', this.mediabox).css('background-image', cur.css('background-image'));

    $('div.container', this.mediabox).css('background-image', 'none');
    if (this.data[this.active][5]) // does it have an image
    {
        this.event_load(show_animation);
        try {

            cur = this;
            var img = new Image();
            $(img).load(bind(cur.event_load_image, cur, show_animation, true));
            $(img).error(bind(cur.event_load_image, cur, show_animation, false));
            img.src = cur.data[this.active][5];
        }
        catch (ex) { this.event_load(show_animation); }
    }
    else {
        // Next image loading has no background, so capture the default and use for the loading fade image
        $('div.container', this.mediabox).css('background-image', $('.mediabox').css('background-image'));
        this.event_load(show_animation);
    }
};
MediaBox.prototype.event_load_image = function(e, self, show_animation, success) {
    if (success) {
        $('div.container', self.mediabox).css('background-image', 'url(' + self.data[self.active][5] + ')');
    }
    self.event_load(show_animation);
};
MediaBox.prototype.reset_timer = function()
{
    if (!this.auto_rotate) return;
    if (this._timer) clearInterval(this._timer);
    this._timer = setInterval(function(c) { return function() {c.rotate()}}(this), this.timer_interval);
};
MediaBox.prototype.event_show = function(e, self)
{
    if (!e) var e = window.event;
    var obj = e.target ? e.target : e.srcElement;
    var parent = $(obj);
    while (parent)
    {
        if (parent.attr('num'))
        {
            self.show(parent.attr('num'), 1);
            break;
        }
        parent = parent.parent();
    }
    e.preventDefault();
};
MediaBox.prototype.event_load_finish = function(self)
{
    self.is_loading = false;
};
MediaBox.prototype.event_load = function(show_animation) {
    var self = this;
    var cur = $('div.container', this.mediabox);
    var data = this.data[this.active];
    $('div.type', this.mediabox).html(data[2]).css('display', (data[2] ? 'block' : 'none'));
    $('a.title', this.mediabox).html(data[0]).attr('href', decode_utf8(data[3]));
    cur.click(bind(this.event_view, this));
    $('div.text', this.mediabox).click(bind(this.event_view, this));
    $('div.summary', this.mediabox).html(' <a href="' + decode_utf8(data[3]) + '">' + data[1] + '</a>');
    if (show_animation) cur.fadeIn(800, function() { self.is_loading = false; });
    else {
        cur.css('display', 'block');
        this.is_loading = false;
    }
    this.reset_timer();
};
MediaBox.prototype.event_view = function(self)
{
    window.location = $('a.title', self.mediabox).attr('href');
};
MediaBox.prototype.event_next = function(e, self)
{
    self.rotate();
};
MediaBox.prototype.event_previous = function(e, self)
{
    self.rotate(1);
};
MediaBox.prototype.rotate = function(go_back)
{
    var n;
    if (go_back)
    {
        n = this.active-1;
        if (n < 0) n = this.data.length-1;
    }
    else
    {
        n = this.active+1;
        if (n >= this.data.length) n = 0;
    }
    this.show(n, 1);
};
MediaBox.prototype.draw_slots = function(page)
{
    if (this.data.length == 1) $('ul.nav', this.mediabox).css('display', 'none');
    var page = parseInt(page);
    if (page*this.pageSize > this.data.length) return;
    this.page = page;
    var cell; var n;
    var cur = $('ul', this.mediabox);
    $('li[@num]', this.mediabox).remove();
    for (var i=0; i<this.pageSize; i++)
    {
        n = i+(page*this.pageSize);
        if (n+1 > this.data.length) break;
        cell = $('<li num="' + n + '" class="row"><a href="' + this.data[n][3] + '"><div class="img"' + (this.data[n][4] ? ' style="background-image: url(\'' + this.data[n][4] + '\');"' : '') + '></div></a></li>');
        cell.click(bind(this.event_show, this)).css('cursor', 'pointer');
        cur.append(cell);
    }
};
MediaBox.prototype.generate = function()
{
    this.mediabox = $('<div class="mediabox"><ul class="nav"></ul><div class="container"></div><div class="previous"></div><div class="text"><div class="type"></div><a class="title"></a><div class="summary"></div></div></div>');
    var cur = $('ul', this.mediabox);
    cur.html($('<li class="prev">Previous</li>').click(bind(this.event_previous, this)));
    cur.append($('<li class="next">Next</li>').click(bind(this.event_next, this)));
    // draw slots
    this.draw_slots(0);
    this.backgroundImage = this.mediabox.css('background-image');
    return this.mediabox;
};