
function _tip_adj(hook, dataobj)
{
    if (!hook || !dataobj) return;
    var h = Geometry.getVerticalScroll()+Geometry.getViewportHeight();
    var w = Geometry.getHorizontalScroll()+Geometry.getViewportWidth();
    if (Geometry.getY(hook)+dataobj.offsetHeight+hook.offsetHeight > h)
    {
        var y = h-dataobj.offsetHeight-15-hook.offsetHeight;
    }
    else
    {
        var y = Geometry.getY(hook) + hook.offsetHeight;
    }
    /*if (Geometry.getX(hook)+hook.offsetWidth+dataobj.offsetWidth+5 > w)
    {
        var x = Geometry.getX(hook) - dataobj.offsetWidth - 5;
    }
    else
    {*/
        var x = Geometry.getX(hook) + hook.offsetWidth + 5;
    //}
    if (x+dataobj.offsetWidth > w) x = w-dataobj.offsetWidth-25;
    
    return [x, y];
}
function getElementWidth(o)
{
    return o.offsetWidth;
}
function getAbsoluteRight(o)
{
    oLeft = o.offsetLeft+o.offsetWidth;
    while(o.offsetParent!=null)
    {
        oParent = o.offsetParent;
        oLeft += oParent.offsetLeft;
        o = oParent;
    }
    return oLeft;
}
function getAbsoluteLeft(o)
{
    oLeft = o.offsetLeft;
    while(o.offsetParent!=null)
    {
        oParent = o.offsetParent;
        oLeft += oParent.offsetLeft;
        o = oParent;
    }
    return oLeft;
}

function getAbsoluteTop(o)
{
    oTop = o.offsetTop;
    while(o.offsetParent!=null)
    {
        oParent = o.offsetParent;
        oTop += oParent.offsetTop;
        o = oParent;
    }
    return oTop;
}

function parseQuery(query)
{
    var Params = new Object ();
    if (!query) return Params; // return empty object
    var Pairs = query.split(/[;&]/);
    for (var i = 0; i < Pairs.length; i++)
    {
        var KeyVal = Pairs[i].split('=');
        if (!KeyVal || KeyVal.length != 2) continue;
        var key = unescape(KeyVal[0]);
        var val = unescape(KeyVal[1]);
        val = val.replace(/\+/g, ' ');
        Params[key] = val;
    }
    return Params;
}

function blockEvents(evt)
{
    if (evt.target) evt.preventDefault();
    else evt.returnValue = false;
}
//new TooltipCache({content_type: [data]})
function TooltipCache(sets) {
    if (sets) this.cache = sets;
    else this.cache = {};
}
TooltipCache.prototype.toString = function() {
    return '[object TooltipCache]';
}
TooltipCache.prototype.fetch = function(ct, id) {
    return this.cache[ct][id];
}
TooltipCache.prototype.extend = function(sets) {
    // Extends an existing TooltipCache dataset by appending
    // `sets` to it.
    for (id in sets) {
        if (!this.cache[id]) this.cache[id] = sets[id];
        else for (sid in sets[id]) { this.cache[id][sid] = sets[id][sid]; }
    }
}
TooltipCache.prototype.cache;
// Maybe theres a better way to handle tooltip templates?
TooltipCache.prototype.content_types = {
    48: 'file_tooltip'
}
TooltipCache.prototype.templates = {
    file_tooltip: {
        value: function(html) { return '<div class="ttl"><div class="ttr">' + html + '</div></div><div class="tbl"><div></div></div>'; },
        className: 'file_tooltip'
    }
}
// TODO: handle classnames
function showTooltip(e, ct, id) {
    var tpl = TooltipCache.prototype.templates[TooltipCache.prototype.content_types[ct]];
    var className = tpl && tpl.className !== undefined ? tpl.className : 'tooltip';
    if (__tooltip_cache__.cache === undefined) return;
    if (!e) var e = window.event;
    var obj = e.target ? e.target : e.srcElement;
    if (__tooltip_cache__.cache[ct] && __tooltip_cache__.cache[ct][id]) {
        var html = __tooltip_cache__.fetch(ct, id);
        var con = $('<div id="cuTooltip" class="' + className + '">' + (tpl && tpl.value !== undefined ? tpl.value(html) : html) + '</div>');
        con.show();
        var xy = _tip_adj(obj, con.get(0));
        con.css({ left: xy[0] + "px", top: xy[1] + "px" });
        $(obj).mouseout(function() { $('#cuTooltip').remove(); })
        $(document.body).append(con);
    }
}
st = showTooltip;