﻿Curse.User = {
    initialize: function() {

        var username = Curse.Utils.getCookie("User.Username");
        if (username != null) {
            Curse.User.username = username;
        }

        var userid = Curse.Utils.getCookie("User.ID");
        if (userid != null) {
            Curse.User.id = userid;
        }

        var roleName = Curse.Utils.getCookie("User.Role");
        if (roleName != null) {
            Curse.User.roleName = roleName;
        }

        var avatarUrl = Curse.Utils.getCookie("User.Avatar");
        if (avatarUrl != null) {
            Curse.User.avatarUrl = avatarUrl;
        }

        var messageCount = Curse.Utils.getCookie("User.MessageCount");
        if (messageCount != null) {
            Curse.User.messageCount = messageCount;
        }
    },
    roles: function() {
        if (this._roles != null) {
            return this._roles;
        }
        var roleList = unescape(Curse.Utils.getCookie("User.RoleList"));
        if (roleList == null) {
            this._roles = [];
        }
        else {
            this._roles = roleList.split(",");
        }
        return this._roles;
    },
    setPrimaryRole: function(rolename) {
        Curse.Utils.setDomainCookie("User.Role", rolename);
        Curse.User.roleName = rolename;
    },
    addRole: function(rolename) {
        var roleList = Curse.User.roles();
        if (!Curse.User.inRole(rolename)) {
            roleList.push(rolename);
        }
        Curse.Utils.setDomainCookie("User.RoleList", roleList.join(","));
        this._roles = roleList;

    },
    inRole: function(roleName) {
        return (Curse.User.roles().indexOf(roleName) >= 0);
    },
    isModerator: function() {
        return (Curse.User.inRole("Curse") || Curse.User.inRole("Moderator"));
    },
    favorites: {

        getByType: function(type) {
            var favs = Curse.Utils.getCookie("User.Favorites." + type);
            if (favs) {
                return favs.split(",");
            }
            else {
                return new Array();
            }
        },
        remove: function(type, id) {
            var currentFavs = Curse.User.favorites.getByType(type);
            if (currentFavs.indexOf(id + "") >= 0) {
                currentFavs.splice(currentFavs.indexOf(id + ""), 1);
            }
            Curse.Utils.setDomainCookie("User.Favorites." + type, currentFavs.join(","));
        },
        add: function(type, id) {
            var currentFavs = Curse.User.favorites.getByType(type);
            if (currentFavs.indexOf(id + "") >= 0) {
                return;
            }
            currentFavs.push(id + "");
            Curse.Utils.setDomainCookie("User.Favorites." + type, currentFavs.join(","));
        }
    },
    siteOptions: {
        getSiteOptions: function() {
            var options = Curse.Utils.getCookie("User.SiteOptions");
            if (options) {
                return options.split(" - ");
            }
            else {
                return new Array();
            }
        },
        updateSiteOption: function(siteOptionName, value) {
            var options = Curse.User.siteOptions.getSiteOptions();
            for (option in options) {
                if (options[option].indexOf(siteOptionName) > -1) {
                    options[option] = siteOptionName + ": " + value;
                    break;
                }
            }
            Curse.Utils.setDomainCookie("User.SiteOptions", options.join(" - "));
        },
        containsSiteOption: function(siteOptionName, value) {
            var options = Curse.User.siteOptions.getSiteOptions();
            for (option in options) {
                if (options[option].indexOf(siteOptionName + ": " + value) > -1) {
                    return true;
                }
            }
        }
    }
};
Curse.User.initialize();