﻿Curse.Form =
{
    formcount: 0,
    actions: {},
    inputs: {},
    validation: {},
    bind: function(settings) {
        Curse.Form.formcount += 1;
        Curse.Form.actions[Curse.Form.formcount] = settings.action;
        Curse.Form.validation[Curse.Form.formcount] = settings.validation;
        var formInput = document.getElementById(settings.input);
        var formButton = document.getElementById(settings.button);
        formButton.onclick = Curse.Form.handleButton.bind(formButton, Curse.Form.formcount);
        formInput.onkeydown = Curse.Form.handleKeyDown.bind(formInput, Curse.Form.formcount);
        Curse.Form.inputs[Curse.Form.formcount] = {};
        Curse.Form.inputs[Curse.Form.formcount][0] = formInput;

    },
    // Binds all inputs under a containing element
    bindAll: function(settings) {
        Curse.Form.formcount += 1;
        Curse.Form.actions[Curse.Form.formcount] = settings.action;
        Curse.Form.validation[Curse.Form.formcount] = settings.validation;
        //var formInputContainer = document.getElementById(settings.input);
        var formButton = document.getElementById(settings.button);
        formButton.onclick = Curse.Form.handleButton.bind(formButton, Curse.Form.formcount);
        var jqueryStr = '#' + settings.input + ' input';
        jqueryStr += ', #' + settings.input + ' select';
        var test = $(jqueryStr);
        var inputCount = 0;
        Curse.Form.inputs[Curse.Form.formcount] = {};
        $(jqueryStr).each(function() {
            var element = this;
            if (element.tagName == "INPUT" && (element.type == "text" || element.type == "password")) {
                element.onkeydown = Curse.Form.handleKeyDown.bind(element, Curse.Form.formcount);
            };
            Curse.Form.inputs[Curse.Form.formcount][inputCount++] = element;
            var currentVal = unescape(Curse.Form.getQueryStringParam(element.name));
            if (currentVal != null && currentVal != "") {
                if (element.tagName == "INPUT") {
                    if (element.type == "checkbox") {
                        element.checked = (currentVal == "1");
                    } else {
                        element.value = currentVal;
                    }
                } else if (element.tagName == "SELECT") {
                    for (var optIdx = 0; optIdx < element.options.length; optIdx++) {
                        if (element.options[optIdx].value == currentVal) {
                            element.selectedIndex = optIdx;
                            break;
                        }
                    }
                }
            }
        });
    },
    initialize: function(settings) {
        Curse.Form.formcount += 1;
        Curse.Form.actions[Curse.Form.formcount] = settings.action;
        Curse.Form.validation[Curse.Form.formcount] = settings.validation;
        document.write("<input id=\"curse_" + Curse.Form.formcount + "_input\" onkeydown=\"return Curse.Form.handleKeyDown(" + Curse.Form.formcount + ",event)\" type=\"text\" name=\"" + settings.name + "\" class=\"global-search\">");
        document.write("<input onclick=\"Curse.Form.handleButton(" + Curse.Form.formcount + ")\" type=\"button\" value=\"" + settings.buttonLabel + "\">");
        Curse.Form.inputs[Curse.Form.formcount] = {};
        Curse.Form.inputs[Curse.Form.formcount][0] = document.getElementById("curse_" + Curse.Form.formcount + "_input");

    },
    handleKeyDown: function(formId, e) {
        var evt = Curse.Utils.getEvent(e);
        if (evt.keyCode == 13) {
            Curse.Utils.cancelBubbling(evt);
            //            return Curse.Form.submit(formId, evt._target);
            return Curse.Form.submit(formId);
        }
    },
    handleButton: function(formId) {
        var action = Curse.Form.actions[formId];
        var input = Curse.Form.inputs[formId];
        //self.location=Curse.Form.getAction(action,input.name+"="+input.value);
        Curse.Form.submit(formId);
    },
    /*
    submit: function(formId, input) {
    var action = Curse.Form.actions[formId];
    self.location = Curse.Form.getAction(action, input.name + "=" + input.value);
    return false;
    },
    */
    submit: function(formId) {
        if (Curse.Form.validation[formId] != null && Curse.Form.validation[formId]() == false) return;
        var action = Curse.Form.actions[formId];
        self.location = Curse.Form.getAction(action, Curse.Form.formatQuery(formId));
        return false;
    },
    formatQuery: function(formId) {
        var query = "";
        var i = 0;
        while (Curse.Form.inputs[formId][i] != null) {
            var input = Curse.Form.inputs[formId][i];
            var val = input.value;
            if (input.type == "checkbox") {
                val = input.checked ? "1" : "0";
            }
            if (val != null && val != "") {
                if (query.length > 0) query += "&";
                val = escape(val).replace(/\+/g, '%2B');
                query += input.name + "=" + val;
            }
            i++;
        }
        return query;
    },
    getAction: function(baseAction, query) {
        if (baseAction.indexOf("?") > 0) {
            return baseAction + "&" + query;
        }
        else {
            return baseAction + "?" + query;
        }
    },
    getQueryStringParam: function(param) {
        param = param.replace(/[\[]/, "\\\[").replace(/[\]]/, "\\\]");
        var regexS = "[\\?&]" + param + "=([^&#]*)";
        var regex = new RegExp(regexS);
        var results = regex.exec(window.location.href);
        if (results == null) {
            return "";
        }
        else {
            return results[1];
        }
    }
};