﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Configuration;

namespace Curse.Mailer
{
    public delegate void LogDelegate(LogLevel level, string message, params object[] args);
    public enum LogLevel
    {
        Info = 0,
        Access = 1,
        Warning = 2,
        Error = 3,
        Debug = 4,
    }

    public class MailProviderConfiguration : ConfigurationSection
    {

        private static MailProviderConfiguration _instance = ConfigurationManager.GetSection("mailProvider") as MailProviderConfiguration;
        public static MailProviderConfiguration Instance
        {
            get
            {
                return _instance;
            }
        }

        // SmtpProviders
        [ConfigurationProperty("templatePath", IsRequired = false)]        
        public string _TemplatePath
        {
            get
            {
                return (string)this["templatePath"];
            }
        }

        public string DynamicTemplatePath { get; set; }

        public static string TemplatePath
        {
            get
            {
                return Instance.DynamicTemplatePath ?? Instance._TemplatePath;
            }
        }
        

        // SmtpProviders
        [ConfigurationProperty("smtpProviders", IsRequired = true)]
        [ConfigurationCollection(typeof(SmtpProviderConfigElement), AddItemName = "smtpProvider")]
        public SmtpProviderConfigElementCollection _SmtpProviders
        {
            get
            {
                return this["smtpProviders"] as SmtpProviderConfigElementCollection;
            }
        }
        public static SmtpProviderConfigElementCollection SmtpProviders
        {
            get
            {
                return Instance._SmtpProviders;
            }
        }

        private static LogDelegate _logDelegate;
        public static LogDelegate LogDelegate
        {
            get
            {
                if (_logDelegate == null)
                {
                    return DefaultLogDelegate;
                }
                else
                {
                    return _logDelegate;
                }
            }
        }

        public static void Initialize(string templatePath)
        {
            Initialize(templatePath, null);
        }

        public static void Initialize(LogDelegate logDelegate)
        {
            Initialize(null, logDelegate);
        }
        
        protected static void Initialize(string templatePath, LogDelegate logDelegate)
        {           
            
            if (logDelegate == null)
            {
                _logDelegate = DefaultLogDelegate;
            }
            else
            {
                _logDelegate = logDelegate;
            }
            IsInitialized = true;
        }

        private static void DefaultLogDelegate(LogLevel level, string message, params object[] args)
        {
            ELogLevel logLevel = (ELogLevel)Enum.Parse(typeof(ELogLevel), level.ToString(), true);
            Logger.Log(message, logLevel, args);
        }
        
        public static bool IsInitialized
        {
            get;
            private set;
        }        

        public static Dictionary<string, string> Templates
        {
            get;
            private set;
        }

        public static bool HasTemplateConfiguration
        {
            get
            {
                return !string.IsNullOrEmpty(TemplatePath);
            }            
        }        

    }
}
