﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Configuration;
using System.Text.RegularExpressions;
using System.Net.Mail;
using System.Net;

namespace Curse.Mailer
{
    public class SmtpProviderConfigElementCollection : ConfigurationElementCollection
    {
        public MailProviderConfiguration this[int index]
        {
            get
            {
                return base.BaseGet(index) as MailProviderConfiguration;
            }
            set
            {
                if (base.BaseGet(index) != null)
                {
                    base.BaseRemoveAt(index);
                }
                this.BaseAdd(index, value);
            }
        }

        protected override ConfigurationElement CreateNewElement()
        {
            return new SmtpProviderConfigElement();
        }

        protected override object GetElementKey(ConfigurationElement element)
        {
            return ((SmtpProviderConfigElement)element).ID;
        }
    }

    public class SmtpProviderConfigElement : ConfigurationElement
    {
        public SmtpProviderConfigElement() { }

        [ConfigurationProperty("id", IsRequired = true)]
        public int ID
        {
            get
            {
                return (int)this["id"];
            }
            internal set
            {
                this["id"] = value;
            }
        }

        [ConfigurationProperty("isDefault", IsRequired = false, DefaultValue = false)]
        public bool IsDefault
        {
            get
            {
                return (bool)this["isDefault"];
            }
            internal set
            {
                this["isDefault"] = value;
            }
        }

        [ConfigurationProperty("isEnabled", IsRequired = true)]
        public bool IsEnabled
        {
            get
            {
                return (bool)this["isEnabled"];
            }
            internal set
            {
                this["isEnabled"] = value;
            }
        }

        [ConfigurationProperty("port", IsRequired = true)]
        public int Port
        {
            get
            {
                return (int)this["port"];
            }
            internal set
            {
                this["port"] = value;
            }
        }

        [ConfigurationProperty("host", IsRequired = true)]
        public string Host
        {
            get
            {
                return (string)this["host"];
            }
            internal set
            {
                this["host"] = value;
            }
        }

        [ConfigurationProperty("isAuthenticated", IsRequired = true)]
        public bool IsAuthenticated
        {
            get
            {
                return (bool)this["isAuthenticated"];
            }
            internal set
            {
                this["isAuthenticated"] = value;
            }
        }

        [ConfigurationProperty("enableSsl", IsRequired = true)]
        public bool EnableSsl
        {
            get
            {
                return (bool)this["enableSsl"];
            }
            internal set
            {
                this["enableSsl"] = value;
            }
        }

        [ConfigurationProperty("username", IsRequired = false)]
        public string Username
        {
            get
            {
                return (string)this["username"];
            }
            internal set
            {
                this["username"] = value;
            }
        }

        [ConfigurationProperty("password", IsRequired = false)]
        public string Password
        {
            get
            {
                return (string)this["password"];
            }
            internal set
            {
                this["password"] = value;
            }
        }

        [ConfigurationProperty("domainSelector", IsRequired = false)]
        public string DomainSelector
        {
            get
            {
                return (string)this["domainSelector"];
            }
            internal set
            {
                this["domainSelector"] = value;
            }
        }


        private Regex _domainSelectorRegex;
        public Regex DomainSelectorRegex
        {
            get
            {
                if (DomainSelector != null && _domainSelectorRegex == null)
                {
                    _domainSelectorRegex = new Regex(DomainSelector, RegexOptions.CultureInvariant | RegexOptions.Compiled);
                }
                return _domainSelectorRegex;
            }
        }

        private SmtpClient _client;
        public SmtpClient Client
        {
            get
            {
                if (_client == null)
                {
                    SmtpClient client = new SmtpClient(Host, Port);
                    if (IsAuthenticated)
                    {
                        client.Credentials = new NetworkCredential(Username, Password, "");
                    }
                    client.EnableSsl = EnableSsl;
                    _client = client;
                }
                return _client;
            }
        }

        public int TotalSendSuccesses
        {
            get;
            set;
        }

        public int TotalSendFailures
        {
            get;
            set;
        }
    } 
}
