﻿using System;

namespace Curse.MurmurHash
{
    public class MurmurHash2
    {
        public static UInt32 GetHashCode(byte[] key, int seed = 1)
        {
            return GetHashCode(key, key.Length, seed);
        }

        public static UInt32 GetHashCode(byte[] key, int len, int seed)
        {
            // 'm' and 'r' are mixing constants generated offline.
            // They're not really 'magic', they just happen to work well.

            UInt32 m = 0x5bd1e995;
            int r = 24;

            UInt32 h = (UInt32)(seed ^ len);

            // Mix 4 bytes at a time into the hash

            byte[] data = key;
            int index = 0;
            while (len >= 4)
            {
                UInt32 k = BitConverter.ToUInt32(data, index);
                k *= m;
                k ^= k >> r;
                k *= m;

                h *= m;
                h ^= k;
                index += 4;
                len -= 4;
            }

            // Handle the last few bytes of the input array

            switch (len)
            {
                case 3:
                    h ^= (UInt32)data[index + 2] << 16;
                    h ^= (UInt32)data[index + 1] << 8;
                    h ^= data[index];
                    h *= m;
                    break;
                case 2: h ^= (UInt32)data[index + 1] << 8;
                    h ^= data[index];
                    h *= m;
                    break;
                case 1: h ^= data[index];
                    h *= m;
                    break;

            };


            // Do a few final mixes of the hash to ensure the last few
            // bytes are well-incorporated.

            h ^= h >> 13;
            h *= m;
            h ^= h >> 15;

            return h;
        } 
    }
}
