﻿using System;
using System.Configuration;
using System.Collections.Generic;
using System.ComponentModel;
using System.Text;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;

namespace Curse.PayPal
{
    [DefaultProperty("Text")]
    [ToolboxData("<{0}:PayPalButton runat=server></{0}:PayPalButton>")]
    public class PayPalButton : WebControl
    {
        [Bindable(true)]
        [Category("Appearance")]
        [DefaultValue("")]

        private static readonly String sCertificateId = null;
        private static readonly String sPaypalCertPath = null;
        private static readonly String sSignerPfxPath = null;
        private static readonly String sSignerPfxPassword = null;
        private static readonly String sBusinessId = null;
        private static readonly String sPayPalUrl = null;
        private static readonly String sUnsubscribeUrl = null;

        public enum ESubscriptionFunction
        {
            Subscribe = 1,
            Modify = 2,
            Unsubscribe = 3,
            NonRecurring = 4
        }
               
        static PayPalButton()
        {
            sCertificateId = ConfigurationManager.AppSettings["Curse_PayPalCertificateId"];
            sPaypalCertPath = ConfigurationManager.AppSettings["Curse_PayPalCertificatePath"];
            sSignerPfxPath = ConfigurationManager.AppSettings["Curse_PayPalSignaturePath"];
            sSignerPfxPassword = ConfigurationManager.AppSettings["Curse_PayPalSignaturePassword"];
            sBusinessId = ConfigurationManager.AppSettings["Curse_PayPalBusinessId"];
            sPayPalUrl = ConfigurationManager.AppSettings["Curse_PayPalUrl"];
            sUnsubscribeUrl = sPayPalUrl + "?cmd=_subscr-find&alias=" + HttpUtility.UrlEncode(sBusinessId);
        }

        private Int32 mCurseId = 0;
        private String mButtonLabel = null;
        private SubscriptionType mSubscriptionType = null;
        private String mReturnlUrl = null;
        private String mCssClass = String.Empty;
        private ESubscriptionFunction mSubscriptionFunction = ESubscriptionFunction.Subscribe;
        
        public Int16 ButtonSubscriptionType
        {            
            set
            {
                mSubscriptionType = SubscriptionType.GetType(value);
                if (mSubscriptionType == null)
                {
                    throw new KeyNotFoundException("The subscription type you requested is invalid.");
                }
                
            }
        }

        public ESubscriptionFunction ButtonSubscriptionFunction
        {
            set
            {
                mSubscriptionFunction = value;
            }
        }

        public String ButtonCssClass
        {
            set
            {
                mCssClass = value;
            }
        }

        public String ButtonLabel
        {
            set
            {
                mButtonLabel = value;
            }
        }

        public Int32 ButtonCurseId
        {
            set
            {
                mCurseId = value;
            }
        }

        public String ButtonReturnUrl
        {
            set
            {
                mReturnlUrl = value;
            }
        }

        private string getNonRecurringForm()
        {
                        
            string clearText = "cmd=_xclick\n" +
               "business=" + sBusinessId + "\n" +
               "amount=" + mSubscriptionType.Cost + "\n" +
               "currency_code=USD\n" +
               "item_name=" + mSubscriptionType.Name + "\n" +
               "item_number=" + mSubscriptionType.Id.ToString() + "\n" +
               "no_shipping=1\n" +
               "no_note=1\n" +
               "quantity_x=1\n" +
               "currency_code=USD\n" +
               "lc=US\n" +                                                           
               "custom=" + mCurseId.ToString() + "\n" +
               "cert_id=" + sCertificateId;

            if (mReturnlUrl != null)
            {
                clearText += "\nreturn=" + mReturnlUrl;
            }
        
            ButtonEncryption ewp = new ButtonEncryption();
            ewp.LoadSignerCredential(sSignerPfxPath, sSignerPfxPassword);
            ewp.RecipientPublicCertPath = sPaypalCertPath;
            String signedData = ewp.SignAndEncrypt(clearText);

            if (mButtonLabel == null)
            {
                mButtonLabel = mSubscriptionType.Name;
            }

            return "<form action=\"" + sPayPalUrl + "\" method=\"POST\">" +
                "<input type=\"hidden\" name=\"cmd\" value=\"_s-xclick\">" +
                "<input type=\"hidden\" name=\"encrypted\" value=\"" + signedData + "\">" +
                "<input class=\"" + mCssClass + "\" type=\"submit\" name=\"submit\" value=\"" + mButtonLabel + "\">" +
                "</form>";
        }

        private string getSubscribeForm()
        {
            string clearText = "cmd=_xclick-subscriptions\n" +
                               "business=" + sBusinessId + "\n" +
                               "currency_code=USD\n" +
                               "item_name=" + mSubscriptionType.Name + "\n" +
                               "item_number=" + mSubscriptionType.Id.ToString() + "\n" +
                               "no_shipping=1\n" +
                               "no_note=1\n" +
                               "currency_code=USD\n" +
                               "lc=US\n" +
                               "bn=PP-SubscriptionsBF\n" +
                               "a3=" + mSubscriptionType.Cost.ToString() + "\n" +
                               "p3=" + mSubscriptionType.TermMonths + "\n" +
                               "t3=M\n" +
                               "src=1\n" +
                               "sra=1\n" +
                               "custom=" + mCurseId.ToString() + "\n" +
                               "cert_id=" + sCertificateId;


            if (mReturnlUrl != null)
            {
                clearText += "\nreturn=" + mReturnlUrl;
            }

            if (mSubscriptionFunction == ESubscriptionFunction.Modify)
            {
                clearText += "\nmodify=2";
            }
            ButtonEncryption ewp = new ButtonEncryption();
            ewp.LoadSignerCredential(sSignerPfxPath, sSignerPfxPassword);
            ewp.RecipientPublicCertPath = sPaypalCertPath;
            String signedData = ewp.SignAndEncrypt(clearText);

            if (mButtonLabel == null)
            {
                mButtonLabel = mSubscriptionType.Name;
            }

            return "<form action=\"" + sPayPalUrl + "\" method=\"POST\">" +
                "<input type=\"hidden\" name=\"cmd\" value=\"_s-xclick\">" +
                "<input type=\"hidden\" name=\"encrypted\" value=\"" + signedData + "\">" +
                "<input class=\"" + mCssClass + "\" type=\"submit\" name=\"submit\" value=\"" + mButtonLabel + "\">" +
                "</form>";
        }
        private string getUnsubscribeButton()
        {

            String label = String.IsNullOrEmpty(mButtonLabel) ? String.Empty : mButtonLabel;
            return "<a class=\"" + mCssClass + "\" href=\"" + sUnsubscribeUrl + "\">" + label + "</a>";
        }

        protected override void RenderContents(HtmlTextWriter output)
        {

            string buttonHtml = null;
            switch (mSubscriptionFunction)
            {
                case ESubscriptionFunction.Subscribe:
                case ESubscriptionFunction.Modify:
                    buttonHtml = getSubscribeForm();
                    break;
                case ESubscriptionFunction.Unsubscribe:
                    buttonHtml = getUnsubscribeButton();
                    break;
                case ESubscriptionFunction.NonRecurring:
                    buttonHtml = getNonRecurringForm();
                    break;

            }

            output.Write(buttonHtml);
        }
    }
}
