﻿using System;
using System.Data.SqlClient;
using System.Configuration;
using System.Collections.Generic;
using System.Text;

namespace Curse.PayPal
{
    public class SubscriptionType
    {
        public Int16 Id = 0;
        public String Name = null;
        public Decimal Cost = 0;
        public Byte TermMonths = 0;


        private static readonly Dictionary<Int16, SubscriptionType> sSubscriptionTypes = new Dictionary<Int16, SubscriptionType>();

        public static SubscriptionType GetType(Int16 pTypeId)
        {

            if (sSubscriptionTypes.ContainsKey(pTypeId))
            {
                return sSubscriptionTypes[pTypeId];
            }
            else
            {
                return null;
            }

        }

        static SubscriptionType()
        {

            using (SqlConnection conn = new SqlConnection(ConfigurationManager.ConnectionStrings["PaymentDB"].ConnectionString))
            {
                conn.Open();
                SqlCommand cmd = conn.CreateCommand();
                cmd.CommandText = "select * from subscription_type";
                using (SqlDataReader reader = cmd.ExecuteReader())
                {
                    while (reader.Read())
                    {
                        sSubscriptionTypes.Add(reader.GetInt16(reader.GetOrdinal("id")), new SubscriptionType(reader.GetInt16(reader.GetOrdinal("id")), reader.GetString(reader.GetOrdinal("name")), reader.GetDecimal(reader.GetOrdinal("cost")), reader.GetByte(reader.GetOrdinal("term_months"))));
                    }
                }
            }

        }


        public SubscriptionType(Int16 pId, String pName, Decimal pCost, Byte pTermMonths)
        {
            Id = pId;
            Name = pName;
            Cost = pCost;
            TermMonths = pTermMonths;
        }

    }
}
