﻿using System;
using System.Runtime.Serialization;

namespace Curse.ServiceAuthentication.Models
{
    [DataContract]
    public class AuthenticationSession
    {
        public static readonly AuthenticationSession Anonymous = new AuthenticationSession();      

        [DataMember]
        public int UserID
        {
            get;
            set;
        }

        [DataMember]
        public string Username
        {
            get;
            set;
        }

        [DataMember]
        public string SessionID
        {
            get;
            set;
        }

        [DataMember]
        public bool EffectivePremiumStatus
        {
            get;
            set;
        }

        [DataMember]
        public bool ActualPremiumStatus
        {
            get;
            set;
        }

        [DataMember]
        public int SubscriptionToken
        {
            get;
            set;
        }

        [DataMember]
        public string Token
        {
            get; 
            set;
        }

        [DataMember]
        public string EmailAddress
        {
            get;
            set;
        }

        public DateTime DateCreated
        {
            get;
            set;

        }
        public DateTime DateLastActive
        {
            get;
            set;
        }

        public DateTime DateRefreshed
        {
            get;
            set;
        }
        
        public bool IsExpired
        {
            get
            {
                return DateTime.UtcNow.Subtract(DateRefreshed).TotalSeconds > 10;
            }
        }       

        public void RecordActivity()
        {
            DateLastActive = DateTime.UtcNow;
        }

        public AuthenticationSession()
        {
            DateCreated = DateTime.UtcNow;
            DateRefreshed = DateTime.UtcNow;
        }                
    }
}
