﻿using System.Runtime.Serialization;
using System.ServiceModel;
using System.ServiceModel.Description;
using System.ServiceModel.Dispatcher;
using System.ServiceModel.Channels;

namespace Curse.ServiceAuthentication.Models
{
    [DataContract(Namespace = HeaderNamespace)]
    public sealed class LegacyAuthenticationToken
    {
        public const string HeaderName = "AuthenticationContext";
        public const string HeaderNamespace = "urn:Curse.ClientService:v1";               

        // These are the fields that will be serialized and passed through the header
        [DataMember]
        public string Username { get; set; }

        [DataMember]
        public string Password { get; set; }
        
        public bool IsAnonymous
        {
            get;
            set;
        }
       
        public static LegacyAuthenticationToken FromHeaders(string username, string encryptedPassword)
        {
            return new LegacyAuthenticationToken() {
                Username = username,
                Password = encryptedPassword
            };
        }

        public static void Initialize(string username, string plainTextPassword)
        {
            _outgoing = new LegacyAuthenticationToken() {
                Username = username,
                Password = AuthenticationEncryption.EncryptPassword(plainTextPassword)
            };
        }

        private static LegacyAuthenticationToken _outgoing;

        // These are the values owned by the client's current
        // thread, that will be passed to the service.
        public static LegacyAuthenticationToken Outgoing
        {
            get
            {
                return _outgoing;
            }
            set
            {
                _outgoing = value;
            }
        }       
    }
    
    public sealed class LegacyAuthTokenExtension : IEndpointBehavior, IClientMessageInspector
    {        
        object IClientMessageInspector.BeforeSendRequest(ref Message request, IClientChannel channel)
        {
            var messageHeader = MessageHeader.CreateHeader(LegacyAuthenticationToken.HeaderName, LegacyAuthenticationToken.HeaderNamespace, LegacyAuthenticationToken.Outgoing);
            request.Headers.Add(messageHeader);            
            return null;
   
        }

        void IEndpointBehavior.ApplyClientBehavior(ServiceEndpoint endpoint, ClientRuntime clientRuntime)
        {
            clientRuntime.MessageInspectors.Add(new LegacyAuthTokenExtension());
        }

        void IClientMessageInspector.AfterReceiveReply(ref Message reply, object correlationState)
        {
            // Do nothing
        }

        void IEndpointBehavior.AddBindingParameters(ServiceEndpoint endpoint, BindingParameterCollection bindingParameters)
        {
            // Do nothing
        }

        void IEndpointBehavior.ApplyDispatchBehavior(ServiceEndpoint endpoint, EndpointDispatcher endpointDispatcher)
        {
            // Do nothing
        }

        void IEndpointBehavior.Validate(ServiceEndpoint endpoint)
        {
            // Do nothing
        }
    }
}
