﻿using System.ServiceModel;
using Curse.ServiceAuthentication.Models;

namespace Curse.ServiceAuthentication
{
    public class AuthenticationContext : IExtension<OperationContext>
    {
        internal AuthenticationContext(AuthenticationSession session, AuthenticationStatus status)
        {
            AuthenticationSession = session;
            AuthenticationStatus = status;
        }

        public AuthenticationSession AuthenticationSession { get; private set; }
        public AuthenticationStatus AuthenticationStatus { get; private set; }

        public static AuthenticationContext Current
        {
            get
            {
                var context = OperationContext.Current.Extensions.Find<AuthenticationContext>();
                if (context == null)
                {
                    context = AuthenticationProvider.CreateAuthenticationContext();
                    OperationContext.Current.Extensions.Add(context);
                }
                return context;
            }
        }

        public void Attach(OperationContext owner) { }
        public void Detach(OperationContext owner) { }
    }
}
