﻿using System;


namespace Curse.ServiceAuthentication
{
    public delegate void LogDelegate(string message, Exception ex = null, object data = null);

    internal static class AuthenticationLogger
    {        
        private static LogDelegate _logDelegate;

        internal static void Initialize(LogDelegate logDelegate)
        {
            _logDelegate = logDelegate;
        }

        internal static void Log(string message, Exception ex = null, object data = null)
        {
            if (_logDelegate == null)
            {
                return;
            }

            _logDelegate(message, ex, data);
        }
    }
}
