﻿using System;
using System.Collections.Generic;
using System.Configuration;
using System.Data.SqlClient;
using System.Threading;

namespace Curse.ServiceAuthentication
{
    internal class UserGrantManager
    {

        private static readonly UserGrantManager _instance = new UserGrantManager();
        private string _databaseConnectionString;
        private HashSet<int> _grantedUserIDs;

        public static UserGrantManager Instance
        {
            get
            {
                return _instance;
            }
        }
     

        public void Initialize(string databaseConnectionString) 
        {
            try
            {
                using (var conn = new SqlConnection(databaseConnectionString))
                {
                    conn.Open();
                }
            }
            catch (Exception ex)
            {
                throw new ArgumentException("UserGrantCache cannot connect to database: " + ex.Message);
            }

            _databaseConnectionString = ConfigurationManager.ConnectionStrings["ClientService"].ConnectionString;

            UpdateCache();

            new Thread(CacheThread) { IsBackground = true, Name = "UserGrantCache" }.Start();     
        }

        private void CacheThread()
        {            
            while (true)
            {
                Thread.Sleep(TimeSpan.FromSeconds(10));
                try
                {
                    UpdateCache();                    

                }
                catch (ThreadAbortException)
                {                    
                    break;
                }
                catch (Exception ex)
                {
                    AuthenticationLogger.Log("UserGrantCache - Update Thread Exception!", ex);
                }
            }
        }

        private void UpdateCache()
        {

            using (var conn = new SqlConnection(_databaseConnectionString))
            {
                try
                {
                    conn.Open();
                }
                catch (Exception ex)
                {
                    AuthenticationLogger.Log("Unable to establish connection to database: " + _databaseConnectionString, ex);
                    return;
                }
                                
                using (var command = conn.CreateCommand())
                {
                    command.CommandText = "select GrantedUserID from UserGrant";

                    var userIDs = new HashSet<int>();                    
                    using (SqlDataReader reader = command.ExecuteReader())
                    {
                        while (reader.Read())
                        {
                            userIDs.Add(reader.GetInt32(0));
                        }
                    }

                    _grantedUserIDs = userIDs;
                }                
            }
        }


        public bool HasGrant(int userID)
        {
            if (_grantedUserIDs == null)
            {
                return false;
            }

            return _grantedUserIDs.Contains(userID);
        }
    }
}