﻿using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.Linq;
using System.Text;

namespace Curse.ServiceEncryption.Tests
{
    class Program
    {
        static void Main(string[] args)
        {
            
            Console.WriteLine("Enter the ecryption key:");
            var key = Console.ReadLine();
            EncryptionToken.Initialize(key, 1);

            while (true)
            {
                Console.Clear();
                Console.WriteLine("Enter an ecrypted token:");
                var encryptedValue = Console.ReadLine();
                var val = EncryptionToken.FromValue(encryptedValue);
                if (val.IsValid)
                {
                    Console.WriteLine("UserID: " + val.GetValue("UserID"));
                    Console.WriteLine("Timestamp: " + val.GetValue("Timestamp"));
                }
                else
                {
                    Console.WriteLine("Token is invalid!");
                }
                Console.ReadLine();
            }            
        }

        static void TestDecryptionSpeed()
        {
            EncryptionToken.Initialize("TEST", 1);

            var encrypted = EncryptionToken.FromDictonary(new Dictionary<string, string> {{"a", "b"}});
            var value = encrypted.Value;

            var sw = Stopwatch.StartNew();
            for(var i=0;i<1000;i++)
            {
                var decrypted = EncryptionToken.FromValue(value);
            }

            sw.Stop();
            Console.Write(sw.ElapsedMilliseconds);
            Console.ReadLine();
        }
    }
}
