﻿using System;
using System.Collections.Generic;
using System.Linq;
using Curse.ServiceModels.Configuration;
using System.Data.SqlClient;

namespace Curse.ServiceModels.Caching
{
    public abstract class Cache<T>
    {
        List<T> _currentResults;
                
        DateTime _lastQueryTime = new DateTime(1900, 1, 1);
        public DateTime LastQueryTime
        {
            get
            {
                return _lastQueryTime.AddMinutes(-5);
            }
            set
            {
                _lastQueryTime = value;
            }
        }
                
        string _dataSourceName;
        string _updateProcedureName;

        object _cacheLock = new object();
        public object CacheLock { get { return _cacheLock; } }

        public Cache(string dataSource, string updateProcedureName) 
        {
            var config = ServiceConfiguration.Instance.Caching;
            _dataSourceName = dataSource;
            _updateProcedureName = updateProcedureName;
            _currentResults = new List<T>();
        }
        public void Initialize() { }

        public List<T> GetCache()
        {
            var results = new List<T>();
            
            using (var conn = DatabaseConfiguration.Instance[_dataSourceName].GetDatabaseConnection())
            {
                var cmd = new SqlCommand(_updateProcedureName, conn);
                cmd.CommandType = System.Data.CommandType.StoredProcedure;

                using (var reader = cmd.ExecuteReader())
                {
                    while (reader.Read())
                    {
                        var cacheObject = Activator.CreateInstance<T>() as ICachable;
                        cacheObject.SetFromDataReader(reader);
                        results.Add((T)cacheObject);
                    }
                }
            }

            lock (CacheLock)
            {
                _currentResults = results;
            }

            return results;
        }
    }
}
