﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Data.SqlClient;

namespace Curse.ServiceModels.Configuration
{
    public class DatabaseConnection
    {
        static string _name;
        static string _connectionString;

        public string Name { get { return _name; } }
        public string ConnectionString { get { return _connectionString; } }

        public DatabaseConnection(string name, string connectionString)
        {
            _name = name;
            _connectionString = connectionString;
        }

        public SqlConnection GetDatabaseConnection()
        {
            var conn = new SqlConnection(_connectionString);
            try
            {
                conn.Open();
            }
            catch (Exception)
            {
                Logger.Log("Unable to establish connection to database: {0}", ELogLevel.Error, _name);
            }
            return conn;
        }
    }
    
    public class DatabaseConfiguration
    {
        static Dictionary<string, DatabaseConnection> _connectionInfo;

        static DatabaseConfiguration _instance = new DatabaseConfiguration();
        public static DatabaseConfiguration Instance { get { return _instance; } }
        
        static DatabaseConfiguration()
        {
            var config = ServiceConfiguration.Instance;

            _connectionInfo = new Dictionary<string, DatabaseConnection>();
            foreach (DatabaseConnectionElement conn in config.DataConnections)
            {
                var databaseName = conn.Key;
                var connectionString = conn.Database.ConnectionString;
                var dbConn = new DatabaseConnection(databaseName, connectionString);
                
                _connectionInfo.Add(databaseName, dbConn);
            }
        }

        public DatabaseConnection this[string databaseName]
        {
            get
            {
                if (_connectionInfo.ContainsKey(databaseName))
                {
                    return _connectionInfo[databaseName];
                }
                else return null;
            }
        }
    }
}
