﻿using System;
using System.Configuration;

namespace Curse.ServiceModels.Configuration
{
    public class DatabaseProviderElement : CurseConfigurationElement
    {
        [ConfigurationProperty("connectionString", IsRequired = true)]
        public string ConnectionString
        {
            get { return (string)this["connectionString"]; }
            set { this["connectionString"] = value; }
        }

        [ConfigurationProperty("providerName", IsRequired = true)]
        public string Provider
        {
            get { return (string)this["providerName"]; }
            set { this["providerName"] = value; }
        }

        [ConfigurationProperty("recycleTime", IsRequired = false)]
        public TimeSpan RecycleTime
        {
            get { return (TimeSpan)this["recycleTime"]; }
            set { this["recycleTime"] = value; }
        }
    }
}
