﻿using System;
using System.Configuration;

namespace Curse.ServiceModels.Configuration
{
    public partial class ServiceConfiguration : ConfigurationSection
    {
        public enum ConfigurationMode
        {
            Development,
            Staging,
            Production
        }

        private static ConfigurationMode _activeConfiguration;
        private static string _activeConfigurationName;

        private static ServiceConfiguration _instance = ConfigurationManager.GetSection("serviceConfiguration") as ServiceConfiguration;
        public static ServiceConfiguration Instance { get { return _instance; } }

        public ServiceConfiguration() { }
        static ServiceConfiguration()
        {
#if CONFIG_DEVELOPMENT
            _activeConfiguration = ConfigurationMode.Development;
#elif CONFIG_STAGING
            _activeConfiguration = ConfigurationMode.Staging;
#elif CONFIG_PRODUCTION
            _activeConfiguration = ConfigurationMode.Production;
#endif
            _activeConfigurationName = _activeConfiguration.ToString().ToLower();
        }
        public static ConfigurationMode ActiveConfiguration { get { return _activeConfiguration; } }
        public static string ActiveConfigurationName { get { return _activeConfigurationName; } }

        [ConfigurationProperty("logging", IsRequired = true)]
        [ConfigurationCollection(typeof(LogProviderElement), AddItemName = "logProvider")]
        CurseConfigurationElementCollection<LogProviderElement> _Logging
        {
            get { return (CurseConfigurationElementCollection<LogProviderElement>)base["logging"]; }
        }

        public LogProviderElement Logging
        {
            get { return _Logging.Active; }
        }

        // Authentication
        [ConfigurationProperty("authentication", IsRequired = true)]
        [ConfigurationCollection(typeof(AuthenticationConfigElement), AddItemName = "authenticationProvider")]
        CurseConfigurationElementCollection<AuthenticationConfigElement> _Authentication
        {
            get { return (CurseConfigurationElementCollection<AuthenticationConfigElement>)this["authentication"]; }
        }

        public AuthenticationConfigElement Authentication
        {
            get
            {
                return Instance._Authentication.Active;
            }
        }

        // Data Connections
        [ConfigurationProperty("dataConnections", IsRequired = false)]
        [ConfigurationCollection(typeof(DatabaseConnectionElement), AddItemName = "dataConnection")]
        public CurseConfigurationElementCollection<DatabaseConnectionElement> DataConnections
        {
            get { return (CurseConfigurationElementCollection<DatabaseConnectionElement>)base["dataConnections"]; }
        }

        // Caching
        [ConfigurationProperty("caching", IsRequired = false)]
        [ConfigurationCollection(typeof(CachingElement), AddItemName = "cacheProvider")]
        CurseConfigurationElementCollection<CachingElement> _Caching
        {
            get { return (CurseConfigurationElementCollection<CachingElement>)base["caching"]; }
        }

        public CachingElement Caching
        {
            get
            {
                return Instance._Caching.Active;
            }
        }

        // Processing
        [ConfigurationProperty("processing", IsRequired = true)]
        [ConfigurationCollection(typeof(ProcessingElement), AddItemName = "processSetting")]
        CurseConfigurationElementCollection<ProcessingElement> _Processing
        {
            get { return (CurseConfigurationElementCollection<ProcessingElement>)base["processing"]; }
        }
        public ProcessingElement Processing
        {
            get
            {
                return Instance._Processing.Active;
            }
        }
    }
}