﻿using System;
using System.Runtime.Serialization;

namespace Curse.ServiceModels.Models
{
    [DataContract]
    public class ServiceResponse
    {
        [DataMember]
        public ServiceResponseStatus Status
        {
            get;
            set;
        }

        [DataMember]
        public string Message
        {
            get;
            set;
        }


        public ServiceResponse() { }

        public ServiceResponse(ServiceResponseStatus status)
        {
            Status = status;
        }

        public ServiceResponse(ServiceResponseStatus status, string message)
        {
            Status = status;
            Message = message;
        }
    }

    [DataContract]
    public class ServiceResponse<T>
    {
        [DataMember]
        public ServiceResponseStatus Status
        {
            get;
            set;
        }

        [DataMember]
        public string Message
        {
            get;
            set;
        }


        [DataMember]
        public T Value
        {
            get;
            set;
        }

        public ServiceResponse() { }

        public ServiceResponse(ServiceResponseStatus status)
        {
            Status = status;

        }

        public ServiceResponse(ServiceResponseStatus status, string message)
        {
            Status = status;
            Message = message;
        }

        public ServiceResponse(ServiceResponseStatus status, T value)
        {
            Status = status;
            Value = value;
        }

        public ServiceResponse(ServiceResponseStatus status, string message, T value)
        {
            Status = status;
            Message = message;
            Value = value;
        }
    }
}
