﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Vindicia;

namespace Curse.Vindicia
{
    public static class Retrieval
    {
        public static Product GetProductByID(string id)
        {
            Product p = new Product();
            Return r = p.fetchByMerchantProductId(id);
            return p;
        }

        public static Account GetAccountByID(string id)
        {
            Account a = new Account();
            Return r = a.fetchByMerchantAccountId(id);
            return a;
        }

        public static BillingPlan GetBillingPlanByID(string id)
        {
            BillingPlan b = new BillingPlan();
            Return r = b.fetchByMerchantBillingPlanId(id);
            return b;
        }

        public static AutoBill GetAutoBillByVID(string vid)
        {
            AutoBill ab = new AutoBill();
            Return r = ab.fetchByVid(vid);
            return ab;
        }

        public static AutoBill[] GetAllAutoBillsByAccountID(string id)
        {
            Account a = new Account();
            a.merchantAccountId = id;
            AutoBill[] autoBills;
            AutoBill ab = new AutoBill();
            ab.fetchByAccount(a, out autoBills);
            return autoBills;
        }

        public static Entitlement[] GetAllEntitlementsByAccountID(string id, bool activeOnly)
        {
            Account a = new Account();
            a.merchantAccountId = id;

            Entitlement b = new Entitlement();
            Entitlement[] entitlements;
            b.fetchByAccount(a, activeOnly, out entitlements);
            return entitlements;
        }

        public static Entitlement[] GetAllEntitlementsByAccountIDAndEntitlementIDs(string accountID, string[] entitlementIDs, bool activeOnly)
        {
            Entitlement[] entitlements = GetAllEntitlementsByAccountID(accountID, activeOnly);
            return entitlements.Where(p => entitlementIDs.Contains(p.merchantEntitlementId)).ToArray();
        }


        public static Entitlement[] GetAllEntitlementsFromDate(DateTime date)
        {            
            Entitlement b = new Entitlement();
            Entitlement[] entitlements;
            b.fetchDeltaSince(date, 0, 1000, DateTime.UtcNow.AddDays(1), out entitlements);
            return entitlements;
        }
    }
}
