﻿using System;
using System.Collections.Generic;
using System.Text;

namespace Curse.WoW.WDB
{
    public class WDBDocument
    {
        private WDBDocumentType mDocumentType = WDBDocumentType.Unknown;
        private String mMagic = "";
        private Int32 mVersion = 0;
        private String mLocale = "";

        public WDBDocument(WDBReader pReader)
        {
            ReadHeader(pReader);
        }

        public WDBDocumentType DocumentType
        {
            get
            {
                return mDocumentType;
            }
        }

        public String Magic
        {
            get
            {
                return mMagic;
            }
        }

        public Int32 Version
        {
            get
            {
                return mVersion;
            }
        }

        public String Locale
        {
            get
            {
                return mLocale;
            }
        }

        protected Boolean Supported
        {
            get
            {
                return Enum.IsDefined(typeof(WDBVersions), mVersion);
            }
        }

        protected void ReadHeader(WDBReader pReader)
        {
            try
            {
                mMagic = pReader.ReadStringReversed(4);
                switch (mMagic)
                {
                    case "WIDB":
                        mDocumentType = WDBDocumentType.ItemCache;
                        break;
                    case "WQST":
                        mDocumentType = WDBDocumentType.QuestCache;
                        break;
                    case "WMOB":
                        mDocumentType = WDBDocumentType.CreatureCache;
                        break;
                    case "WPTX":
                        mDocumentType = WDBDocumentType.PageTextCache;
                        break;
                    case "WGOB":
                        mDocumentType = WDBDocumentType.GameObjectCache;
                        break;
                    default:
                        break;
                }
                mVersion = pReader.Version = pReader.ReadInt32();
                mLocale = pReader.ReadStringReversed(4);
                pReader.Skip(12);
            }
            catch (Exception)
            {
                throw new WDBException("Unable to read header");
            }
        }

        public virtual void Read(WDBReader pReader) { }
    }
}
