﻿using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.IO;
using System.Text;

namespace Curse.WoW.WDB
{
    public sealed class WDBReader
        : BinaryReader
    {
        private static Encoding sStringEncoding = Encoding.GetEncoding(1252);
        private Int32 mVersion = 0;

        public WDBReader(String pPath)
            : base(new FileStream(pPath, FileMode.Open, FileAccess.Read), sStringEncoding)
        {
        }

        public Int64 Length
        {
            get
            {
                return BaseStream.Length - BaseStream.Position;
            }
        }

        public Int32 Version
        {
            get
            {               
               return mVersion;               
            }
            set
            {
                mVersion = value;
            }
        }

        public void Skip(Int64 pCount)
        {
            BaseStream.Seek(pCount, SeekOrigin.Current);
        }
        public void Rewind(Int64 pCount)
        {
            BaseStream.Seek(pCount * -1, SeekOrigin.Current);
        }

        public void SkipNext(Char pValue)
        {
            while (ReadChar() != pValue) ;
        }
        public void SkipNext(Char pValue, Int32 pRepetitions)
        {
            while (pRepetitions-- > 0)
            {
                SkipNext(pValue);
            }
        }

        public override String ReadString()
        {
            StringBuilder buf = new StringBuilder();
            Char c;
            while ((c = ReadChar()) != '\0')
            {
                buf.Append(c);
            }
            return buf.ToString();
        }
        public String ReadString(Int32 pLength)
        {
            Byte[] data = ReadBytes(pLength);
            return sStringEncoding.GetString(data);
        }

        public String ReadStringReversed(Int32 pLength)
        {
            Byte[] data = ReadBytes(pLength);
            Array.Reverse(data);
            return sStringEncoding.GetString(data);
        }

        public void Dump(Int32 pLength)
        {
            Byte[] buf = new Byte[16];
            Int32 read;
            for (Int32 count = 0; count < pLength; count += 16)
            {
                read = Read(buf, 0, Math.Min(16, pLength - count));
                Debug.Write(BitConverter.ToString(buf, 0, read));
                if (read < 16)
                {
                    Debug.Write(new String(' ', ((16 - read) * 3) - 1));
                }
                Debug.WriteLine(" " + Encoding.ASCII.GetString(buf, 0, read) + "\r\n");
            }
            Rewind(pLength);
        }
    }
}
