﻿using System;
using System.Collections.Generic;
using System.Text;

namespace Curse.WoW.WDB
{
    public sealed class WIDBDamage
        : IPackable
    {
        public Int32 Type = 0;
        public Single Min = 0.0f;
        public Single Max = 0.0f;

        public void Read(WDBReader pReader)
        {
            Min = pReader.ReadSingle();
            Max = pReader.ReadSingle();
            Type = pReader.ReadInt32();
        }

        public Boolean Write(IWriteable pBuf)
        {
            return pBuf.Write(Type) &&
                   pBuf.Write(Min) &&
                   pBuf.Write(Max);
        }

        public Boolean Read(IReadable pBuf)
        {
            return pBuf.Read(ref Type) &&
                   pBuf.Read(ref Min) &&
                   pBuf.Read(ref Max);
        }
    }
}
