﻿using System;
using System.Collections.Generic;
using System.Text;

namespace Curse.WoW.WDB
{
    public sealed class WIDBDocument
        : WDBDocument
    {
        public List<WIDBItem> Items = new List<WIDBItem>();

        public WIDBDocument(WDBReader pReader)
            : base(pReader)
        {
        }

        public override void Read(WDBReader reader)
        {
            if (!Supported)
            {
                throw new WDBException("Unsupported version for item cache");
            }

            WIDBItem item = null;
            while (reader.Length > 8)
            {
                item = new WIDBItem();
                item.Read(reader);
                Items.Add(item);
            }
        }
    }
}
