﻿using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.Text;

namespace Curse.WoW.WDB
{
    public sealed class WIDBItem
        : IPackable
    {
        public Int32 Id = 0;
        public Int32 ClassId = 0;
        public Int32 SubClassId = 0;
        public String Name = "";
        public Int32 DisplayId = 0;
        public Int32 QualityId = 0;
        public Int32 Type = 0;
        public Int32 BuyPrice = 0;
        public Int32 SellPrice = 0;
        public Int32 InventorySlot = 0;
        public Int32 Classes = 0;
        public Int32 Races = 0;
        public Int32 Level = 0;
        public Int32 RequiredLevel = 0;
        public Int32 RequiredSkill = 0;
        public Int32 RequiredSkillLevel = 0;
        public Int32 RequiredSpell = 0;
        public Int32 RequiredRank = 0;
        public Int32 RequiredFaction = 0;
        public Int32 RequiredFactionLevel = 0;
        public Int32 MaxUnique = 0;
        public Int32 MaxStackSize = 0;
        public Int32 ContainerSlots = 0;
        public PackableList<WIDBStatistic> Statistics = new PackableList<WIDBStatistic>();
        public PackableList<WIDBDamage> Damages = new PackableList<WIDBDamage>();
        public Int32 PhysicalResistance = 0;
        public Int32 HolyResistance = 0;
        public Int32 FireResistance = 0;
        public Int32 NatureResistance = 0;
        public Int32 FrostResistance = 0;
        public Int32 ShadowResistance = 0;
        public Int32 ArcaneResistance = 0;
        public Int32 WeaponDelay = 0;
        public Int32 AmmoType = 0;
        public Single RangeModifier = 0.0f;
        public PackableList<WIDBSpell> Spells = new PackableList<WIDBSpell>();
        public Int32 Bond = 0;
        public String Description = "";
        public Int32 BookText = 0;
        public Int32 BookPages = 0;
        public Int32 BookStationary = 0;
        public Int32 BeginsQuest = 0;
        public Int32 LockPickRequirement = 0;
        public Int32 Material = 0;
        public Int32 Sheath = 0;
        public Int32 Random1Property = 0;
        public Int32 Random2Property = 0;
        public Int32 BlockValue = 0;
        public Int32 Set = 0;
        public Int32 Durability = 0;
        public Int32 Area = 0;
        public Int32 Map = 0;
        public Int32 BagFamily = 0;
        public Int32 TotemCategory = 0;
        public Int32 Socket1 = 0;
        public Int32 Socket2 = 0;
        public Int32 Socket3 = 0;
        public Int32 Enchantment = 0;
        public Int32 GemProperties = 0;
        public Int32 ExtendedCost = 0;
        public Int32 CondExtendedCost = 0;
        public Int32 RequiredDisenchantSkillLevel = 0;
        public Single ArmorDamageModifier = 0.0f;
        public Int32 Faction = 0;
        public Int32 ExistingDuration = 0;
        public Int32 ItemLimitCategory = 0;
        public Int32 HolidayID = 0;

        public void Read(WDBReader pReader)
        {
            Id = pReader.ReadInt32();
            Int32 length = pReader.ReadInt32();
            Int64 begin = pReader.Length;

            ClassId = pReader.ReadInt32();
            SubClassId = pReader.ReadInt32();
            pReader.Skip(4);
            Name = pReader.ReadString();
            pReader.SkipNext('\0', 3); //Name repeats 3 times

            DisplayId = pReader.ReadInt32();
            QualityId = pReader.ReadInt32();
            Type = pReader.ReadInt32();
            BuyPrice = pReader.ReadInt32();

            if (pReader.Version >= (Int32)WDBVersions.WowVersion_3_3_0)
            {
                Faction = pReader.ReadInt32();
            }
            
            SellPrice = pReader.ReadInt32();
            InventorySlot = pReader.ReadInt32();
            Classes = pReader.ReadInt32();
            Races = pReader.ReadInt32();
            Level = pReader.ReadInt32();
            RequiredLevel = pReader.ReadInt32();
            RequiredSkill = pReader.ReadInt32();
            RequiredSkillLevel = pReader.ReadInt32();
            RequiredSpell = pReader.ReadInt32();
            RequiredRank = pReader.ReadInt32();
            pReader.Skip(4);
            RequiredFaction = pReader.ReadInt32();
            RequiredFactionLevel = pReader.ReadInt32();
            MaxUnique = pReader.ReadInt32();
            MaxStackSize = pReader.ReadInt32();
            ContainerSlots = pReader.ReadInt32();
            Int32 statLength = pReader.ReadInt32();
            for (Int32 index = 0; index <= statLength; ++index)
            {
                Statistics.Add(new WIDBStatistic());
                Statistics[index].Read(pReader);
            }
            for (Int32 index = 0; index < 2; ++index)
            {
                Damages.Add(new WIDBDamage());
                Damages[index].Read(pReader);
            }
            PhysicalResistance = pReader.ReadInt32();
            HolyResistance = pReader.ReadInt32();
            FireResistance = pReader.ReadInt32();
            NatureResistance = pReader.ReadInt32();
            FrostResistance = pReader.ReadInt32();
            ShadowResistance = pReader.ReadInt32();
            ArcaneResistance = pReader.ReadInt32();
            WeaponDelay = pReader.ReadInt32();
            AmmoType = pReader.ReadInt32();
            RangeModifier = pReader.ReadSingle();
            for (Int32 index = 0; index < 5; ++index)
            {
                Spells.Add(new WIDBSpell());
                Spells[index].Read(pReader);
            }
            Bond = pReader.ReadInt32();
            Description = pReader.ReadString();
            BookText = pReader.ReadInt32();
            BookPages = pReader.ReadInt32();
            BookStationary = pReader.ReadInt32();
            BeginsQuest = pReader.ReadInt32();
            LockPickRequirement = pReader.ReadInt32();
            Material = pReader.ReadInt32();
            Sheath = pReader.ReadInt32();
            Random1Property = pReader.ReadInt32();
            Random2Property = pReader.ReadInt32();
            BlockValue = pReader.ReadInt32();
            Set = pReader.ReadInt32();
            Durability = pReader.ReadInt32();
            Area = pReader.ReadInt32();
            Map = pReader.ReadInt32();
            BagFamily = pReader.ReadInt32();
            TotemCategory = pReader.ReadInt32();
            Socket1 = pReader.ReadInt32();
            pReader.Skip(4);
            Socket2 = pReader.ReadInt32();
            pReader.Skip(4);
            Socket3 = pReader.ReadInt32();
            pReader.Skip(4);
            Enchantment = pReader.ReadInt32();
            GemProperties = pReader.ReadInt32();
            if (pReader.Version < (Int32)WDBVersions.WowVersion_2_4_0)
            {
                ExtendedCost = pReader.ReadInt32();

                if (pReader.Version > (Int32)WDBVersions.WowVersion_2_2_0)
                {
                    CondExtendedCost = pReader.ReadInt32();
                }
            }
            RequiredDisenchantSkillLevel = pReader.ReadInt32();
            ArmorDamageModifier = pReader.ReadSingle();

            if (pReader.Version >= (Int32)WDBVersions.WowVersion_2_4_2)
            {
                ExistingDuration = pReader.ReadInt32();
            }

            if (pReader.Version >= (Int32)WDBVersions.WowVersion_3_0_1)
            {
                ItemLimitCategory = pReader.ReadInt32();
            }

            if(pReader.Version >= (Int32)WDBVersions.WowVersion_3_1_0)
            {
                HolidayID = pReader.ReadInt32();
            }

            

            Debug.Assert(begin - pReader.Length == length);
        }

        public Boolean Write(IWriteable pBuf)
        {
            return pBuf.Write(Id) &&
                   pBuf.Write(ClassId) &&
                   pBuf.Write(SubClassId) &&
                   pBuf.Write(Name) &&
                   pBuf.Write(Description) &&
                   pBuf.Write(DisplayId) &&
                   pBuf.Write(QualityId) &&
                   pBuf.Write(Type) &&
                   pBuf.Write(BuyPrice) &&
                   pBuf.Write(SellPrice) &&
                   pBuf.Write(InventorySlot) &&
                   pBuf.Write(Classes) &&
                   pBuf.Write(Races) &&
                   pBuf.Write(Level) &&
                   pBuf.Write(RequiredLevel) &&
                   pBuf.Write(RequiredSkill) &&
                   pBuf.Write(RequiredSkillLevel) &&
                   pBuf.Write(RequiredSpell) &&
                   pBuf.Write(RequiredRank) &&
                   pBuf.Write(RequiredFaction) &&
                   pBuf.Write(RequiredFactionLevel) &&
                   pBuf.Write(MaxUnique) &&
                   pBuf.Write(MaxStackSize) &&
                   pBuf.Write(ContainerSlots) &&
                   pBuf.Write(PhysicalResistance) &&
                   pBuf.Write(HolyResistance) &&
                   pBuf.Write(FireResistance) &&
                   pBuf.Write(NatureResistance) &&
                   pBuf.Write(FrostResistance) &&
                   pBuf.Write(ShadowResistance) &&
                   pBuf.Write(ArcaneResistance) &&
                   pBuf.Write(WeaponDelay) &&
                   pBuf.Write(AmmoType) &&
                   pBuf.Write(Bond) &&
                   pBuf.Write(BookText) &&
                   pBuf.Write(BookPages) &&
                   pBuf.Write(BookStationary) &&
                   pBuf.Write(BeginsQuest) &&
                   pBuf.Write(LockPickRequirement) &&
                   pBuf.Write(Material) &&
                   pBuf.Write(Sheath) &&
                   pBuf.Write(BlockValue) &&
                   pBuf.Write(Set) &&
                   pBuf.Write(Durability) &&
                   pBuf.Write(Area) &&
                   pBuf.Write(Map) &&
                   pBuf.Write(BagFamily) &&
                   pBuf.Write(TotemCategory) &&
                   pBuf.Write(Enchantment) &&
                   pBuf.Write(GemProperties) &&
                   pBuf.Write(ExtendedCost) &&
                   pBuf.Write(CondExtendedCost) &&
                   pBuf.Write(RequiredDisenchantSkillLevel) &&
                   pBuf.Write(ArmorDamageModifier) &&
                   pBuf.Write(RangeModifier) &&
                   pBuf.Write(Random1Property) &&
                   pBuf.Write(Random2Property) &&
                   pBuf.Write(Socket1) &&
                   pBuf.Write(Socket2) &&
                   pBuf.Write(Socket3) &&
                   Statistics.Write(pBuf) &&
                   Damages.Write(pBuf) &&
                   Spells.Write(pBuf);
        }

        public Boolean Read(IReadable pBuf)
        {
            bool ok = pBuf.Read(ref Id) &&
                   pBuf.Read(ref ClassId) &&
                   pBuf.Read(ref SubClassId) &&
                   pBuf.Read(ref Name) &&
                   pBuf.Read(ref Description) &&
                   pBuf.Read(ref DisplayId) &&
                   pBuf.Read(ref QualityId) &&
                   pBuf.Read(ref Type) &&
                   pBuf.Read(ref BuyPrice) &&
                   pBuf.Read(ref SellPrice) &&
                   pBuf.Read(ref InventorySlot) &&
                   pBuf.Read(ref Classes) &&
                   pBuf.Read(ref Races) &&
                   pBuf.Read(ref Level) &&
                   pBuf.Read(ref RequiredLevel) &&
                   pBuf.Read(ref RequiredSkill) &&
                   pBuf.Read(ref RequiredSkillLevel) &&
                   pBuf.Read(ref RequiredSpell) &&
                   pBuf.Read(ref RequiredRank) &&
                   pBuf.Read(ref RequiredFaction) &&
                   pBuf.Read(ref RequiredFactionLevel) &&
                   pBuf.Read(ref MaxUnique) &&
                   pBuf.Read(ref MaxStackSize) &&
                   pBuf.Read(ref ContainerSlots) &&
                   pBuf.Read(ref PhysicalResistance) &&
                   pBuf.Read(ref HolyResistance) &&
                   pBuf.Read(ref FireResistance) &&
                   pBuf.Read(ref NatureResistance) &&
                   pBuf.Read(ref FrostResistance) &&
                   pBuf.Read(ref ShadowResistance) &&
                   pBuf.Read(ref ArcaneResistance) &&
                   pBuf.Read(ref WeaponDelay) &&
                   pBuf.Read(ref AmmoType) &&
                   pBuf.Read(ref Bond) &&
                   pBuf.Read(ref BookText) &&
                   pBuf.Read(ref BookPages) &&
                   pBuf.Read(ref BookStationary) &&
                   pBuf.Read(ref BeginsQuest) &&
                   pBuf.Read(ref LockPickRequirement) &&
                   pBuf.Read(ref Material) &&
                   pBuf.Read(ref Sheath) &&
                   pBuf.Read(ref BlockValue) &&
                   pBuf.Read(ref Set) &&
                   pBuf.Read(ref Durability) &&
                   pBuf.Read(ref Area) &&
                   pBuf.Read(ref Map) &&
                   pBuf.Read(ref BagFamily) &&
                   pBuf.Read(ref TotemCategory) &&
                   pBuf.Read(ref Enchantment) &&
                   pBuf.Read(ref GemProperties) &&
                   pBuf.Read(ref ExtendedCost) &&
                   pBuf.Read(ref CondExtendedCost) &&
                   pBuf.Read(ref RequiredDisenchantSkillLevel) &&
                   pBuf.Read(ref ArmorDamageModifier) &&
                   pBuf.Read(ref RangeModifier) &&
                   pBuf.Read(ref Random1Property) &&
                   pBuf.Read(ref Random2Property) &&
                   pBuf.Read(ref Socket1) &&
                   pBuf.Read(ref Socket2) &&
                   pBuf.Read(ref Socket3);

            ok = ok & Statistics.Read(pBuf) &&
                   Damages.Read(pBuf) &&
                   Spells.Read(pBuf);

            return ok;
        }
    }
}
