﻿using System;
using System.Collections.Generic;
using System.Text;

namespace Curse.WoW.WDB
{
    public sealed class WIDBSpell
        : IPackable
    {
        public Int32 Id = 0;
        public Int32 Trigger = 0;
        public Int32 Charges = 0;
        public Int32 Cooldown = 0;
        public Int32 Category = 0;
        public Int32 CategoryCooldown = 0;

        public void Read(WDBReader pReader)
        {
            Id = pReader.ReadInt32();
            Trigger = pReader.ReadInt32();
            Charges = pReader.ReadInt32();
            Cooldown = pReader.ReadInt32();
            Category = pReader.ReadInt32();
            CategoryCooldown = pReader.ReadInt32();
        }

        public Boolean Write(IWriteable pBuf)
        {
            return pBuf.Write(Id) &&
                   pBuf.Write(Trigger) &&
                   pBuf.Write(Charges) &&
                   pBuf.Write(Cooldown) &&
                   pBuf.Write(Category) &&
                   pBuf.Write(CategoryCooldown);
        }

        public Boolean Read(IReadable pBuf)
        {
            return pBuf.Read(ref Id) &&
                   pBuf.Read(ref Trigger) &&
                   pBuf.Read(ref Charges) &&
                   pBuf.Read(ref Cooldown) &&
                   pBuf.Read(ref Category) &&
                   pBuf.Read(ref CategoryCooldown);
        }
    }
}
