﻿using System;
using System.Collections.Generic;
using System.Text;

namespace Curse.WoW.WDB
{
    public sealed class WIDBStatistic
        : IPackable
    {
        public Int32 Id = 0;
        public Int32 Value = 0;

        public void Read(WDBReader pReader)
        {
            Id = pReader.ReadInt32();
            Value = pReader.ReadInt32();
        }

        public Boolean Write(IWriteable pBuf)
        {
            return pBuf.Write(Id) &&
                   pBuf.Write(Value);
        }

        public Boolean Read(IReadable pBuf)
        {
            return pBuf.Read(ref Id) &&
                   pBuf.Read(ref Value);
        }
    }
}
