﻿using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.Text;

namespace Curse.WoW.WDB
{
    public sealed class WMOBCreature
        : IPackable
    {
        public Int32 Id = 0;
        public String Name = "";
        public String Description = "";
        public Int32 Type = 0;
        public Int32 Family = 0;
        public Int32 Flag = 0;
        public Int32 SpellData = 0;
        public Int32 Display1Info = 0;
        public Int32 Display2Info = 0;
        public Int32 Display3Info = 0;
        public Int32 Display4Info = 0;

        public void Read(WDBReader pReader)
        {
            Id = pReader.ReadInt32();
            Int32 length = pReader.ReadInt32();
            Int64 begin = pReader.Length;

            Name = pReader.ReadString();
            pReader.SkipNext('\0', 3);
            Description = pReader.ReadString();
            if (pReader.Version > (Int32)WDBVersions.WowVersion_2_2_0)
            {
                pReader.SkipNext('\0');
            }
            pReader.Skip(4);
            Type = pReader.ReadInt32();
            Family = pReader.ReadInt32();
            Flag = pReader.ReadInt32();
            pReader.Skip(4);
            SpellData = pReader.ReadInt32();
            Display1Info = pReader.ReadInt32();
            Display2Info = pReader.ReadInt32();
            Display3Info = pReader.ReadInt32();
            Display4Info = pReader.ReadInt32();
            long leftOverBytes = length - (begin - pReader.Length);
            
            pReader.Skip(leftOverBytes);
            
            
            Debug.Assert(begin - pReader.Length == length);
        }

        public Boolean Write(IWriteable pBuf)
        {
            return pBuf.Write(Id) &&
                   pBuf.Write(Name) &&
                   pBuf.Write(Description) &&
                   pBuf.Write(Type) &&
                   pBuf.Write(Family) &&
                   pBuf.Write(Flag) &&
                   pBuf.Write(SpellData) &&
                   pBuf.Write(Display1Info) &&
                   pBuf.Write(Display2Info) &&
                   pBuf.Write(Display3Info) &&
                   pBuf.Write(Display4Info);
        }

        public Boolean Read(IReadable pBuf)
        {
            return pBuf.Read(ref Id) &&
                   pBuf.Read(ref Name) &&
                   pBuf.Read(ref Description) &&
                   pBuf.Read(ref Type) &&
                   pBuf.Read(ref Family) &&
                   pBuf.Read(ref Flag) &&
                   pBuf.Read(ref SpellData) &&
                   pBuf.Read(ref Display1Info) &&
                   pBuf.Read(ref Display2Info) &&
                   pBuf.Read(ref Display3Info) &&
                   pBuf.Read(ref Display4Info);
        }
    }
}
